/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.health;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.health.IndexHealthStats;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class HealthResponseBody
implements JsonpSerializable {
    private final int activePrimaryShards;
    private final int activeShards;
    @Nullable
    private final String activeShardsPercent;
    private final double activeShardsPercentAsNumber;
    private final String clusterName;
    private final int delayedUnassignedShards;
    private final Map<String, IndexHealthStats> indices;
    private final int initializingShards;
    private final int numberOfDataNodes;
    private final int numberOfInFlightFetch;
    private final int numberOfNodes;
    private final int numberOfPendingTasks;
    private final int relocatingShards;
    private final HealthStatus status;
    @Nullable
    private final Time taskMaxWaitingInQueue;
    private final long taskMaxWaitingInQueueMillis;
    private final boolean timedOut;
    private final int unassignedPrimaryShards;
    private final int unassignedShards;

    protected HealthResponseBody(AbstractBuilder<?> builder) {
        this.activePrimaryShards = ApiTypeHelper.requireNonNull(builder.activePrimaryShards, (Object)this, "activePrimaryShards", 0);
        this.activeShards = ApiTypeHelper.requireNonNull(builder.activeShards, (Object)this, "activeShards", 0);
        this.activeShardsPercent = builder.activeShardsPercent;
        this.activeShardsPercentAsNumber = ApiTypeHelper.requireNonNull(builder.activeShardsPercentAsNumber, (Object)this, "activeShardsPercentAsNumber", 0.0);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.delayedUnassignedShards = ApiTypeHelper.requireNonNull(builder.delayedUnassignedShards, (Object)this, "delayedUnassignedShards", 0);
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.initializingShards = ApiTypeHelper.requireNonNull(builder.initializingShards, (Object)this, "initializingShards", 0);
        this.numberOfDataNodes = ApiTypeHelper.requireNonNull(builder.numberOfDataNodes, (Object)this, "numberOfDataNodes", 0);
        this.numberOfInFlightFetch = ApiTypeHelper.requireNonNull(builder.numberOfInFlightFetch, (Object)this, "numberOfInFlightFetch", 0);
        this.numberOfNodes = ApiTypeHelper.requireNonNull(builder.numberOfNodes, (Object)this, "numberOfNodes", 0);
        this.numberOfPendingTasks = ApiTypeHelper.requireNonNull(builder.numberOfPendingTasks, (Object)this, "numberOfPendingTasks", 0);
        this.relocatingShards = ApiTypeHelper.requireNonNull(builder.relocatingShards, (Object)this, "relocatingShards", 0);
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.taskMaxWaitingInQueue = builder.taskMaxWaitingInQueue;
        this.taskMaxWaitingInQueueMillis = ApiTypeHelper.requireNonNull(builder.taskMaxWaitingInQueueMillis, (Object)this, "taskMaxWaitingInQueueMillis", 0L);
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, (Object)this, "timedOut", false);
        this.unassignedPrimaryShards = ApiTypeHelper.requireNonNull(builder.unassignedPrimaryShards, (Object)this, "unassignedPrimaryShards", 0);
        this.unassignedShards = ApiTypeHelper.requireNonNull(builder.unassignedShards, (Object)this, "unassignedShards", 0);
    }

    public final int activePrimaryShards() {
        return this.activePrimaryShards;
    }

    public final int activeShards() {
        return this.activeShards;
    }

    @Nullable
    public final String activeShardsPercent() {
        return this.activeShardsPercent;
    }

    public final double activeShardsPercentAsNumber() {
        return this.activeShardsPercentAsNumber;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final int delayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public final Map<String, IndexHealthStats> indices() {
        return this.indices;
    }

    public final int initializingShards() {
        return this.initializingShards;
    }

    public final int numberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public final int numberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public final int numberOfNodes() {
        return this.numberOfNodes;
    }

    public final int numberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public final int relocatingShards() {
        return this.relocatingShards;
    }

    public final HealthStatus status() {
        return this.status;
    }

    @Nullable
    public final Time taskMaxWaitingInQueue() {
        return this.taskMaxWaitingInQueue;
    }

    public final long taskMaxWaitingInQueueMillis() {
        return this.taskMaxWaitingInQueueMillis;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final int unassignedPrimaryShards() {
        return this.unassignedPrimaryShards;
    }

    public final int unassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("active_primary_shards");
        generator.write(this.activePrimaryShards);
        generator.writeKey("active_shards");
        generator.write(this.activeShards);
        if (this.activeShardsPercent != null) {
            generator.writeKey("active_shards_percent");
            generator.write(this.activeShardsPercent);
        }
        generator.writeKey("active_shards_percent_as_number");
        generator.write(this.activeShardsPercentAsNumber);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("delayed_unassigned_shards");
        generator.write(this.delayedUnassignedShards);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, IndexHealthStats> item0 : this.indices.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initializing_shards");
        generator.write(this.initializingShards);
        generator.writeKey("number_of_data_nodes");
        generator.write(this.numberOfDataNodes);
        generator.writeKey("number_of_in_flight_fetch");
        generator.write(this.numberOfInFlightFetch);
        generator.writeKey("number_of_nodes");
        generator.write(this.numberOfNodes);
        generator.writeKey("number_of_pending_tasks");
        generator.write(this.numberOfPendingTasks);
        generator.writeKey("relocating_shards");
        generator.write(this.relocatingShards);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (this.taskMaxWaitingInQueue != null) {
            generator.writeKey("task_max_waiting_in_queue");
            this.taskMaxWaitingInQueue.serialize(generator, mapper);
        }
        generator.writeKey("task_max_waiting_in_queue_millis");
        generator.write(this.taskMaxWaitingInQueueMillis);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("unassigned_primary_shards");
        generator.write(this.unassignedPrimaryShards);
        generator.writeKey("unassigned_shards");
        generator.write(this.unassignedShards);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupHealthResponseBodyDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::activePrimaryShards, JsonpDeserializer.integerDeserializer(), "active_primary_shards");
        op.add(AbstractBuilder::activeShards, JsonpDeserializer.integerDeserializer(), "active_shards");
        op.add(AbstractBuilder::activeShardsPercent, JsonpDeserializer.stringDeserializer(), "active_shards_percent");
        op.add(AbstractBuilder::activeShardsPercentAsNumber, JsonpDeserializer.doubleDeserializer(), "active_shards_percent_as_number");
        op.add(AbstractBuilder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(AbstractBuilder::delayedUnassignedShards, JsonpDeserializer.integerDeserializer(), "delayed_unassigned_shards");
        op.add(AbstractBuilder::indices, JsonpDeserializer.stringMapDeserializer(IndexHealthStats._DESERIALIZER), "indices");
        op.add(AbstractBuilder::initializingShards, JsonpDeserializer.integerDeserializer(), "initializing_shards");
        op.add(AbstractBuilder::numberOfDataNodes, JsonpDeserializer.integerDeserializer(), "number_of_data_nodes");
        op.add(AbstractBuilder::numberOfInFlightFetch, JsonpDeserializer.integerDeserializer(), "number_of_in_flight_fetch");
        op.add(AbstractBuilder::numberOfNodes, JsonpDeserializer.integerDeserializer(), "number_of_nodes");
        op.add(AbstractBuilder::numberOfPendingTasks, JsonpDeserializer.integerDeserializer(), "number_of_pending_tasks");
        op.add(AbstractBuilder::relocatingShards, JsonpDeserializer.integerDeserializer(), "relocating_shards");
        op.add(AbstractBuilder::status, HealthStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::taskMaxWaitingInQueue, Time._DESERIALIZER, "task_max_waiting_in_queue");
        op.add(AbstractBuilder::taskMaxWaitingInQueueMillis, JsonpDeserializer.longDeserializer(), "task_max_waiting_in_queue_millis");
        op.add(AbstractBuilder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(AbstractBuilder::unassignedPrimaryShards, JsonpDeserializer.integerDeserializer(), "unassigned_primary_shards");
        op.add(AbstractBuilder::unassignedShards, JsonpDeserializer.integerDeserializer(), "unassigned_shards");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Integer activePrimaryShards;
        private Integer activeShards;
        @Nullable
        private String activeShardsPercent;
        private Double activeShardsPercentAsNumber;
        private String clusterName;
        private Integer delayedUnassignedShards;
        @Nullable
        private Map<String, IndexHealthStats> indices;
        private Integer initializingShards;
        private Integer numberOfDataNodes;
        private Integer numberOfInFlightFetch;
        private Integer numberOfNodes;
        private Integer numberOfPendingTasks;
        private Integer relocatingShards;
        private HealthStatus status;
        @Nullable
        private Time taskMaxWaitingInQueue;
        private Long taskMaxWaitingInQueueMillis;
        private Boolean timedOut;
        private Integer unassignedPrimaryShards;
        private Integer unassignedShards;

        public final BuilderT activePrimaryShards(int value) {
            this.activePrimaryShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT activeShards(int value) {
            this.activeShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT activeShardsPercent(@Nullable String value) {
            this.activeShardsPercent = value;
            return (BuilderT)this.self();
        }

        public final BuilderT activeShardsPercentAsNumber(double value) {
            this.activeShardsPercentAsNumber = value;
            return (BuilderT)this.self();
        }

        public final BuilderT clusterName(String value) {
            this.clusterName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT delayedUnassignedShards(int value) {
            this.delayedUnassignedShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT indices(Map<String, IndexHealthStats> map) {
            this.indices = AbstractBuilder._mapPutAll(this.indices, map);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(String key, IndexHealthStats value) {
            this.indices = AbstractBuilder._mapPut(this.indices, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(String key, Function<IndexHealthStats.Builder, ObjectBuilder<IndexHealthStats>> fn) {
            return this.indices(key, fn.apply(new IndexHealthStats.Builder()).build());
        }

        public final BuilderT initializingShards(int value) {
            this.initializingShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numberOfDataNodes(int value) {
            this.numberOfDataNodes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numberOfInFlightFetch(int value) {
            this.numberOfInFlightFetch = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numberOfNodes(int value) {
            this.numberOfNodes = value;
            return (BuilderT)this.self();
        }

        public final BuilderT numberOfPendingTasks(int value) {
            this.numberOfPendingTasks = value;
            return (BuilderT)this.self();
        }

        public final BuilderT relocatingShards(int value) {
            this.relocatingShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT status(HealthStatus value) {
            this.status = value;
            return (BuilderT)this.self();
        }

        public final BuilderT taskMaxWaitingInQueue(@Nullable Time value) {
            this.taskMaxWaitingInQueue = value;
            return (BuilderT)this.self();
        }

        public final BuilderT taskMaxWaitingInQueue(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.taskMaxWaitingInQueue(fn.apply(new Time.Builder()).build());
        }

        public final BuilderT taskMaxWaitingInQueueMillis(long value) {
            this.taskMaxWaitingInQueueMillis = value;
            return (BuilderT)this.self();
        }

        public final BuilderT timedOut(boolean value) {
            this.timedOut = value;
            return (BuilderT)this.self();
        }

        public final BuilderT unassignedPrimaryShards(int value) {
            this.unassignedPrimaryShards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT unassignedShards(int value) {
            this.unassignedShards = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

