/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.xjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.xjson.spi.Config;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class JsonKit {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static Mapper toMapper(String json) {
        return Config.json().toMapper(json);
    }

    public static Mapper toMapper(byte[] jsonBytes) {
        return Config.json().toMapper((InputStream)new ByteArrayInputStream(jsonBytes), CHARSET);
    }

    public static Array toArray(String json) {
        return Config.json().toArray(json);
    }

    public static Array toArray(byte[] jsonBytes) {
        return Config.json().toArray((InputStream)new ByteArrayInputStream(jsonBytes), CHARSET);
    }

    public static <T> T toBean(Type type, String json) {
        return (T)Config.json().toBean(type, json);
    }

    public static <T> T toBean(Type type, byte[] jsonBytes) {
        return (T)Config.json().toBean(type, (InputStream)new ByteArrayInputStream(jsonBytes), CHARSET);
    }

    public static <T> T toBean(TypeRef<T> typeRef, String json) {
        return JsonKit.toBean(typeRef.getType(), json);
    }

    public static <T> T toBean(TypeRef<T> typeRef, byte[] jsonBytes) {
        return JsonKit.toBean(typeRef.getType(), jsonBytes);
    }

    public static <T> List<T> toList(Class<T> type, String json) {
        return Config.json().toList(type, json);
    }

    public static <T> List<T> toList(Class<T> type, byte[] jsonBytes) {
        return Config.json().toList(type, (InputStream)new ByteArrayInputStream(jsonBytes), CHARSET);
    }

    public static String toJson(Object object) {
        return Config.json().serialize(object);
    }

    public static String toJson(Object object, boolean pretty) {
        return Config.json().serialize(object, pretty);
    }

    public static String toPretty(Object object) {
        return Config.json().serialize(object, true);
    }

    public static byte[] toBytes(Object object) {
        return Config.json().serialize(object, CHARSET);
    }
}

