/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.implement;

import cn.zhxu.bs.SearchException;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlSnippet;
import cn.zhxu.bs.util.StringUtils;
import java.util.Objects;

public class DefaultSnippetResolver
implements SnippetResolver {
    private String paramPrefix = ":";
    private String[] paramEndFlags = new String[]{" ", "\t", "\n", "\r", "+", "-", "*", "/", "=", "!", ">", "<", ",", ")", "'", "%", "."};
    private final char[] quotations = new char[]{'\'', '\"'};

    @Override
    public SqlSnippet resolve(String fragment) {
        SqlSnippet sqlSnippet = this.newSqlSnippet();
        int idx1 = fragment.indexOf(this.paramPrefix);
        while (idx1 >= 0) {
            if (idx1 > 0 && fragment.charAt(idx1 - 1) == '\\') {
                fragment = idx1 == 1 ? fragment.substring(idx1) : fragment.substring(0, idx1 - 1) + fragment.substring(idx1);
                int nIdx = idx1 + this.paramPrefix.length() - 1;
                if (nIdx >= fragment.length()) break;
                idx1 = fragment.indexOf(this.paramPrefix, nIdx);
                continue;
            }
            int idx2 = this.findParamEndIndex(fragment, idx1);
            String sqlName = this.getSqlName(fragment, idx1, idx2);
            if (StringUtils.isBlank(sqlName) || sqlName.length() < 2) {
                throw new SearchException("There is a syntax error about embed param: " + fragment);
            }
            SqlSnippet.SqlPara param = this.newSqlSnippetParam(sqlName);
            boolean endWithPrefix = sqlName.endsWith(this.paramPrefix);
            if (endWithPrefix) {
                param.setName(sqlName.substring(1, sqlName.length() - this.paramPrefix.length()));
            } else {
                param.setName(sqlName.substring(1));
            }
            int quotationCount1 = StringUtils.containCount(fragment, 0, idx1, this.quotations);
            int quotationCount2 = StringUtils.containCount(fragment, Math.max(idx1, idx2), fragment.length(), this.quotations);
            if ((quotationCount1 + quotationCount2) % 2 != 0) {
                throw new SearchException("There is a syntax error (quotations mismatch): " + fragment);
            }
            int nIdx = idx1 + sqlName.length();
            if (quotationCount1 % 2 == 0 && !endWithPrefix) {
                param.setJdbcPara(true);
                fragment = fragment.replaceFirst(sqlName, "?");
                nIdx = nIdx - sqlName.length() + 1;
            }
            sqlSnippet.addPara(param);
            idx1 = fragment.indexOf(this.paramPrefix, nIdx);
        }
        sqlSnippet.setSql(fragment);
        return sqlSnippet;
    }

    protected SqlSnippet newSqlSnippet() {
        return new SqlSnippet();
    }

    protected SqlSnippet.SqlPara newSqlSnippetParam(String sqlName) {
        return new SqlSnippet.SqlPara(sqlName);
    }

    protected String getSqlName(String sqlSnippet, int index1, int index2) {
        if (index2 > 0) {
            return sqlSnippet.substring(index1, index2);
        }
        return sqlSnippet.substring(index1);
    }

    protected int findParamEndIndex(String sqlSnippet, int fromIndex) {
        int index = -1;
        for (String flag : this.paramEndFlags) {
            int index0 = sqlSnippet.indexOf(flag, fromIndex);
            if (index < 0) {
                index = index0;
                continue;
            }
            if (index0 <= 0) continue;
            index = Math.min(index, index0);
        }
        return index;
    }

    public String getParamPrefix() {
        return this.paramPrefix;
    }

    public void setParamPrefix(String paramPrefix) {
        this.paramPrefix = Objects.requireNonNull(paramPrefix);
    }

    public String[] getParamEndFlags() {
        return this.paramEndFlags;
    }

    public void setParamEndFlags(String[] paramEndFlags) {
        this.paramEndFlags = Objects.requireNonNull(paramEndFlags);
    }

    public char[] getQuotations() {
        return this.quotations;
    }
}

