/*
 * Decompiled with CFR 0.152.
 */
package cn.wanghaomiao.xpath.core;

import cn.wanghaomiao.xpath.core.XContext;
import cn.wanghaomiao.xpath.model.Node;
import cn.wanghaomiao.xpath.model.Predicate;
import cn.wanghaomiao.xpath.util.EmMap;

public class NodeTreeBuilderStateMachine {
    BuilderState state = BuilderState.SCOPE;
    XContext context = new XContext();
    int cur = 0;
    StringBuilder accum = new StringBuilder();

    public Predicate genPredicate(String pre) {
        int index;
        StringBuilder op = new StringBuilder();
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        Predicate predicate = new Predicate();
        char[] preArray = pre.toCharArray();
        int argDeep = 0;
        int opFlag = 0;
        if (pre.matches(".+(\\+|=|-|>|<|>=|<=|^=|\\*=|$=|~=|!=|!~)\\s*'.+'")) {
            for (index = preArray.length - 1; index >= 0; --index) {
                char tmp = preArray[index];
                if (tmp == '\'') {
                    ++argDeep;
                }
                if (argDeep == 1 && tmp != '\'') {
                    right.insert(0, tmp);
                    continue;
                }
                if (argDeep == 2 && EmMap.getInstance().commOpChar.contains(Character.valueOf(tmp))) {
                    op.insert(0, tmp);
                    opFlag = 1;
                    continue;
                }
                if (argDeep < 2 || opFlag <= 0) continue;
                ++argDeep;
                left.insert(0, tmp);
            }
        } else if (pre.matches(".+(\\+|=|-|>|<|>=|<=|^=|\\*=|$=|~=|!=|!~)[^']+")) {
            while (index >= 0) {
                char tmp = preArray[index];
                if (opFlag == 0 && EmMap.getInstance().commOpChar.contains(Character.valueOf(tmp))) {
                    op.insert(0, tmp);
                } else if (op.length() > 0) {
                    left.insert(0, tmp);
                    opFlag = 1;
                } else {
                    right.insert(0, tmp);
                }
                --index;
            }
        }
        predicate.setOpEm(EmMap.getInstance().opEmMap.get(op.toString()));
        predicate.setLeft(left.toString().trim());
        predicate.setRight(right.toString().trim());
        predicate.setValue(pre);
        return predicate;
    }

    static enum BuilderState {
        SCOPE{

            @Override
            public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
                while (stateMachine.cur < xpath.length) {
                    if (xpath[stateMachine.cur] != '/' && xpath[stateMachine.cur] != '.') {
                        stateMachine.state = AXIS;
                        Node xn = new Node();
                        stateMachine.context.xpathTr.add(xn);
                        xn.setScopeEm(EmMap.getInstance().scopeEmMap.get(stateMachine.accum.toString()));
                        stateMachine.accum = new StringBuilder();
                        break;
                    }
                    stateMachine.accum.append(xpath[stateMachine.cur]);
                    ++stateMachine.cur;
                }
            }
        }
        ,
        AXIS{

            @Override
            public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
                StringBuilder accumTmp = new StringBuilder();
                for (int curtmp = stateMachine.cur; curtmp < xpath.length && xpath[curtmp] != '[' && xpath[curtmp] != '/'; ++curtmp) {
                    if (xpath[curtmp] == ':') {
                        stateMachine.context.xpathTr.getLast().setAxis(accumTmp.toString());
                        stateMachine.cur = curtmp + 2;
                        stateMachine.state = TAG;
                        break;
                    }
                    accumTmp.append(xpath[curtmp]);
                }
                stateMachine.state = TAG;
            }
        }
        ,
        TAG{

            @Override
            public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
                while (stateMachine.cur < xpath.length && xpath[stateMachine.cur] != '[' && xpath[stateMachine.cur] != '/') {
                    stateMachine.accum.append(xpath[stateMachine.cur]);
                    ++stateMachine.cur;
                }
                stateMachine.context.xpathTr.getLast().setTagName(stateMachine.accum.toString());
                stateMachine.accum = new StringBuilder();
                if (stateMachine.cur == xpath.length) {
                    stateMachine.state = END;
                } else if (xpath[stateMachine.cur] == '/') {
                    stateMachine.state = SCOPE;
                } else if (xpath[stateMachine.cur] == '[') {
                    stateMachine.state = PREDICATE;
                }
            }
        }
        ,
        PREDICATE{

            @Override
            public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
                int deep = 0;
                ++stateMachine.cur;
                while (xpath[stateMachine.cur] != ']' || deep != 0) {
                    if (xpath[stateMachine.cur] == '[') {
                        ++deep;
                    }
                    if (xpath[stateMachine.cur] == ']') {
                        --deep;
                    }
                    stateMachine.accum.append(xpath[stateMachine.cur]);
                    ++stateMachine.cur;
                }
                Predicate predicate = stateMachine.genPredicate(stateMachine.accum.toString());
                stateMachine.context.xpathTr.getLast().setPredicate(predicate);
                stateMachine.accum = new StringBuilder();
                if (stateMachine.cur < xpath.length - 1) {
                    ++stateMachine.cur;
                    stateMachine.state = SCOPE;
                } else {
                    stateMachine.state = END;
                }
            }
        }
        ,
        END{

            @Override
            public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
            }
        };


        public void parser(NodeTreeBuilderStateMachine stateMachine, char[] xpath) {
        }
    }
}

