/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.ClaimsHolder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PayloadSerializer
extends StdSerializer<ClaimsHolder> {
    public PayloadSerializer() {
        this((Class<ClaimsHolder>)null);
    }

    private PayloadSerializer(Class<ClaimsHolder> t) {
        super(t);
    }

    @Override
    public void serialize(ClaimsHolder holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        HashMap<String, Object> safePayload = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : holder.getClaims().entrySet()) {
            if ("aud".equals(e.getKey())) {
                if (e.getValue() instanceof String) {
                    safePayload.put(e.getKey(), e.getValue());
                    break;
                }
                String[] audArray = (String[])e.getValue();
                if (audArray.length == 1) {
                    safePayload.put(e.getKey(), audArray[0]);
                    continue;
                }
                if (audArray.length <= 1) continue;
                safePayload.put(e.getKey(), audArray);
                continue;
            }
            if ("exp".equals(e.getKey()) || "iat".equals(e.getKey()) || "nbf".equals(e.getKey())) {
                safePayload.put(e.getKey(), this.dateToSeconds((Date)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof Date) {
                safePayload.put(e.getKey(), this.dateToSeconds((Date)e.getValue()));
                continue;
            }
            safePayload.put(e.getKey(), e.getValue());
        }
        gen.writeObject(safePayload);
    }

    private long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

