/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.socket;

import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpReceive
implements AutoCloseable {
    private final int port;
    private final DatagramSocket ds;

    public UdpReceive(int port) throws IOException {
        this.port = port;
        this.ds = new DatagramSocket(port);
        this.ds.setSendBufferSize(4096);
        this.ds.setSoTimeout(10000);
    }

    public UdpReceive bufferSize(int bufferSize) throws SocketException {
        this.ds.setSendBufferSize(bufferSize);
        return this;
    }

    public UdpReceive timeout(int timeOut) throws SocketException {
        this.ds.setSoTimeout(timeOut);
        return this;
    }

    public int receive(byte[] bs) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, bs.length);
        this.ds.receive(packet);
        return packet.getLength();
    }

    public int receive(byte[] bs, int len) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, len);
        this.ds.receive(packet);
        return packet.getLength();
    }

    public int receive(byte[] bs, int off, int len) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, off, len);
        this.ds.receive(packet);
        return packet.getLength();
    }

    public DatagramPacket receivePacket(byte[] bs) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, bs.length);
        this.ds.receive(packet);
        return packet;
    }

    public DatagramPacket receivePacket(byte[] bs, int len) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, len);
        this.ds.receive(packet);
        return packet;
    }

    public DatagramPacket receivePacket(byte[] bs, int off, int len) throws IOException {
        DatagramPacket packet = new DatagramPacket(bs, off, len);
        this.ds.receive(packet);
        return packet;
    }

    @Override
    public void close() {
        Streams.close((AutoCloseable)this.ds);
    }

    public int getPort() {
        return this.port;
    }

    public DatagramSocket getDatagramSocket() {
        return this.ds;
    }
}

