/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.socket;

import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class TcpSend
implements AutoCloseable,
Flushable {
    private final String host;
    private final int port;
    private final Socket socket;
    private final InputStream in;
    private final OutputStream out;

    public TcpSend(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.socket = new Socket(host, port);
        this.socket.setSendBufferSize(4096);
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(true);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    public TcpSend bufferSize(int bufferSize) throws SocketException {
        this.socket.setSendBufferSize(bufferSize);
        return this;
    }

    public TcpSend timeout(int timeOut) throws SocketException {
        this.socket.setSoTimeout(timeOut);
        return this;
    }

    public TcpSend send(byte send) throws IOException {
        this.out.write(send);
        return this;
    }

    public TcpSend send(byte[] send) throws IOException {
        this.out.write(send);
        return this;
    }

    public TcpSend send(byte[] send, int off, int len) throws IOException {
        this.out.write(send, off, len);
        return this;
    }

    public TcpSend sendLf() throws IOException {
        this.out.write(13);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public int read(byte[] bs) throws IOException {
        return this.read(bs, 0, bs.length);
    }

    public int read(byte[] bs, int off, int len) throws IOException {
        int available = this.in.available();
        if (available <= 0) {
            return 0;
        }
        return this.in.read(bs, off, len);
    }

    @Override
    public void close() {
        Streams.close((AutoCloseable)this.socket);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InputStream getInput() {
        return this.in;
    }

    public OutputStream getOutput() {
        return this.out;
    }
}

