/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.host.ssh;

import cn.orionsec.kit.lang.support.Attempt;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.net.host.ssh.IHostExecutor;
import com.jcraft.jsch.Channel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;

public abstract class BaseHostExecutor<T extends Channel>
implements IHostExecutor {
    protected final T channel;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected Consumer<InputStream> streamHandler;
    protected Runnable callback;
    protected volatile boolean done;

    public BaseHostExecutor(T channel) {
        this.channel = channel;
    }

    @Override
    public void callback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public void transfer(OutputStream out) throws IOException {
        this.streamHandler = Attempt.rethrows(i -> Streams.transfer((InputStream)i, (OutputStream)out));
    }

    @Override
    public void streamHandler(Consumer<InputStream> streamHandler) {
        this.streamHandler = streamHandler;
    }

    @Override
    public void write(byte[] command) {
        try {
            this.outputStream.write(command);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void sendSignal(String signal) {
        try {
            this.channel.sendSignal(signal);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    protected abstract void listenerOutput();

    public void close() {
        Streams.close((AutoCloseable)this.inputStream);
        Streams.close((AutoCloseable)this.outputStream);
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public T getChannel() {
        return this.channel;
    }
}

