/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.host.sftp.transfer;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.net.host.sftp.SftpExecutor;
import cn.orionsec.kit.net.host.sftp.SftpFile;
import cn.orionsec.kit.net.specification.transfer.BaseFileDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class SftpDownloader
extends BaseFileDownloader {
    private static final String LOCK_SUFFIX = "osd";
    private final SftpExecutor executor;
    private InputStream in;

    public SftpDownloader(SftpExecutor executor, String remote, String local) {
        this(executor, remote, new File(local));
    }

    public SftpDownloader(SftpExecutor executor, String remote, File local) {
        super(remote, local, LOCK_SUFFIX, 32768);
        Valid.notNull((Object)executor, (String)"sftp executor is null", (Object[])new Object[0]);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SftpExecutor sftpExecutor = this.executor;
            synchronized (sftpExecutor) {
                super.startDownload();
            }
        }
        catch (IOException e) {
            throw Exceptions.sftp((String)("sftp download exception remote file: " + this.remote + " -> local file: " + this.local.getAbsolutePath()), (Throwable)e);
        }
    }

    @Override
    protected long getRemoteFileSize() {
        SftpFile remoteFile = this.executor.getFile(this.remote);
        if (remoteFile == null) {
            throw Exceptions.notFound((String)"not found download remote file");
        }
        return remoteFile.getSize();
    }

    @Override
    protected void initDownload(boolean breakPoint, long skip) throws IOException {
        this.in = breakPoint ? this.executor.openInputStream(this.remote, skip) : this.executor.openInputStream(this.remote);
    }

    @Override
    protected int read(byte[] bs) throws IOException {
        return this.in.read(bs);
    }

    @Override
    protected void transferFinish() {
        this.close();
    }

    public void close() {
        Streams.close((AutoCloseable)this.in);
    }

    @Override
    public void abort() {
        Streams.close((AutoCloseable)((Object)this.executor));
    }

    public SftpExecutor getExecutor() {
        return this.executor;
    }
}

