/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.host.sftp;

import cn.orionsec.kit.lang.define.StreamEntry;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.net.host.sftp.ISftpExecutor;
import cn.orionsec.kit.net.host.sftp.SftpErrorMessage;
import cn.orionsec.kit.net.host.sftp.SftpFile;
import cn.orionsec.kit.net.host.sftp.SftpFileFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class BaseSftpExecutor
implements ISftpExecutor {
    protected String charset;
    protected int bufferSize = 32768;

    protected BaseSftpExecutor() {
    }

    @Override
    public void makeDirectories(String path) {
        this.doMakeDir(path, this::makeDirectory);
    }

    @Override
    public void remove(String path) {
        try {
            SftpFile file = this.getFile(path);
            if (file == null) {
                return;
            }
            if (file.isDirectory()) {
                List<SftpFile> files = this.list(path);
                for (SftpFile f : files) {
                    if (f.isDirectory()) {
                        this.remove(f.getPath());
                        continue;
                    }
                    this.removeFile(f.getPath());
                }
                this.removeDir(path);
            } else {
                this.removeFile(path);
            }
        }
        catch (Exception e) {
            if (SftpErrorMessage.NO_SUCH_FILE.isCause(e)) {
                return;
            }
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public void move(String source, String target) {
        try {
            source = Files1.getPath((String)source);
            target = Files1.getPath((String)target);
            if (target.charAt(0) == '/') {
                if (!this.isSameParentPath(source, target)) {
                    this.makeDirectories(Files1.getParentPath((String)target));
                }
                this.doMove(source, Files1.getPath((String)Files1.normalize((String)target)));
            } else {
                this.doMove(source, Files1.getPath((String)Files1.normalize((String)Files1.getPath((String)(source + "/../" + target)))));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
    }

    @Override
    public long transfer(String path, OutputStream out, long skip, int size) throws IOException {
        return this.doTransfer(path, out, skip, size, false);
    }

    @Override
    public long transfer(String path, String file, long skip) throws IOException {
        return this.doTransfer(path, Files1.openOutputStreamFast((String)file), skip, -1, true);
    }

    @Override
    public void write(String path, InputStream in) throws IOException {
        this.doWrite(path, in, null);
    }

    @Override
    public void write(String path, byte[] bs, int off, int len) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs, off, len));
    }

    @Override
    public void append(String path, InputStream in) throws IOException {
        this.doAppend(path, in, null);
    }

    @Override
    public void append(String path, byte[] bs, int off, int len) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs, off, len));
    }

    @Override
    public void uploadFile(String remoteFile, String localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamFast((String)localFile), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void uploadFile(String remoteFile, InputStream in, boolean close) throws IOException {
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(in, this.bufferSize);
            this.doWrite(remoteFile, buffer, null);
            if (!close) return;
        }
        catch (Throwable throwable) {
            if (!close) throw throwable;
            Streams.close((AutoCloseable)in);
            Streams.close(buffer);
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        Streams.close((AutoCloseable)buffer);
    }

    @Override
    public void uploadDir(String remoteDir, String localDir, boolean child) throws IOException {
        localDir = Files1.getPath((String)localDir);
        List dirs = Files1.listDirs((String)localDir, (boolean)child);
        List files = Files1.listFiles((String)localDir, (boolean)child);
        for (File dir : dirs) {
            this.makeDirectories(Files1.getPath((String)remoteDir, (String)dir.getAbsolutePath().substring(localDir.length())));
        }
        for (File file : files) {
            String path = Files1.getPath((String)remoteDir, (String)file.getAbsolutePath().substring(localDir.length()));
            this.uploadFile(path, file);
        }
    }

    @Override
    public void downloadFile(String remoteFile, String localFile) throws IOException {
        this.downloadFile(remoteFile, Files1.openOutputStreamFast((String)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, OutputStream out, boolean close) throws IOException {
        this.doTransfer(remoteFile, out, 0L, -1, close);
    }

    @Override
    public void downloadDir(String remoteDir, String localDir, boolean child) throws IOException {
        if (this.getFile(remoteDir = Files1.getPath((String)remoteDir)) == null) {
            throw Exceptions.sftp((String)("not found file " + remoteDir));
        }
        if (!child) {
            List<SftpFile> list = this.listFiles(remoteDir, false);
            for (SftpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)Files1.getFileName((String)s.getPath())));
            }
        } else {
            List<SftpFile> list = this.listDirs(remoteDir, true);
            for (SftpFile s : list) {
                Files1.mkdirs((String)Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
            list = this.listFiles(remoteDir, true);
            for (SftpFile s : list) {
                this.downloadFile(s.getPath(), Files1.getPath((String)localDir, (String)s.getPath().substring(remoteDir.length())));
            }
        }
    }

    @Override
    public List<SftpFile> listFiles(String path, boolean child, boolean dir) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.list(path);
            for (SftpFile l : ls) {
                if (l.isDirectory()) {
                    if (dir) {
                        list.add(l);
                    }
                    if (!child) continue;
                    list.addAll(this.listFiles(Files1.getPath((String)path, (String)l.getName()), true, dir));
                    continue;
                }
                list.add(l);
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<SftpFile> listDirs(String path, boolean child) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.list(path);
            for (SftpFile l : ls) {
                if (!l.isDirectory()) continue;
                list.add(l);
                if (!child) continue;
                list.addAll(this.listDirs(Files1.getPath((String)path, (String)l.getName()), true));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<SftpFile> listFilesFilter(String path, SftpFileFilter filter, boolean child, boolean dir) {
        return this.doListFiles(path, filter, child, dir);
    }

    protected abstract void doMove(String var1, String var2);

    protected void doMakeDir(String path, Consumer<String> creative) {
        SftpFile file = this.getFile(path, false);
        if (file != null && file.isDirectory()) {
            return;
        }
        List parentPaths = Files1.getParentPaths((String)path);
        parentPaths.add(path);
        boolean check = true;
        for (String parentPath : parentPaths) {
            SftpFile parent;
            if (check && ((parent = this.getFile(parentPath, false)) == null || !parent.isDirectory())) {
                check = false;
            }
            if (check) continue;
            try {
                creative.accept(parentPath);
            }
            catch (Exception e) {
                throw Exceptions.sftp((Throwable)e);
            }
        }
    }

    protected abstract long doTransfer(String var1, OutputStream var2, long var3, int var5, boolean var6) throws IOException;

    protected abstract void doWrite(String var1, InputStream var2, StreamEntry var3) throws IOException;

    protected abstract void doAppend(String var1, InputStream var2, StreamEntry var3) throws IOException;

    private List<SftpFile> doListFiles(String path, SftpFileFilter filter, boolean child, boolean dir) {
        ArrayList<SftpFile> list = new ArrayList<SftpFile>();
        try {
            List<SftpFile> ls = this.list(path);
            for (SftpFile l : ls) {
                String fn = l.getName();
                boolean isDir = l.isDirectory();
                if ((!isDir || dir) && filter.test(l)) {
                    list.add(l);
                }
                if (!isDir || !child) continue;
                list.addAll(this.doListFiles(Files1.getPath((String)path, (String)fn), filter, true, dir));
            }
        }
        catch (Exception e) {
            throw Exceptions.sftp((Throwable)e);
        }
        return list;
    }

    protected boolean isSameParentPath(String source, String target) {
        return Files1.getParentPath((String)source).equals(Files1.getParentPath((String)target));
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

