/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.host;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.net.host.SessionProxyType;
import cn.orionsec.kit.net.host.sftp.SftpExecutor;
import cn.orionsec.kit.net.host.ssh.command.CommandExecutor;
import cn.orionsec.kit.net.host.ssh.shell.ShellExecutor;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;

public class SessionStore
implements SafeCloseable {
    private static final String COMMAND_TYPE = "exec";
    private static final String SHELL_TYPE = "shell";
    private static final String SFTP_TYPE = "sftp";
    private static final String AUTH_FAIL_MESSAGE = "auth fail";
    protected final Session session;

    public SessionStore(Session session) {
        this.session = session;
    }

    public SessionStore config(String key, String value) {
        this.session.setConfig(key, value);
        return this;
    }

    public SessionStore password(String password) {
        this.session.setPassword(password);
        return this;
    }

    public SessionStore password(byte[] password) {
        this.session.setPassword(password);
        return this;
    }

    public SessionStore httpProxy(String host, int port) {
        return this.proxy(SessionProxyType.HTTP, host, port, null, null);
    }

    public SessionStore httpProxy(String host, int port, String username, String password) {
        return this.proxy(SessionProxyType.HTTP, host, port, username, password);
    }

    public SessionStore socks4Proxy(String host, int port) {
        return this.proxy(SessionProxyType.SOCKS4, host, port, null, null);
    }

    public SessionStore socks4Proxy(String host, int port, String username, String password) {
        return this.proxy(SessionProxyType.SOCKS4, host, port, username, password);
    }

    public SessionStore socks5Proxy(String host, int port) {
        return this.proxy(SessionProxyType.SOCKS5, host, port, null, null);
    }

    public SessionStore socks5Proxy(String host, int port, String username, String password) {
        return this.proxy(SessionProxyType.SOCKS5, host, port, username, password);
    }

    public SessionStore proxy(SessionProxyType type, String host, int port) {
        return this.proxy(type, host, port, null, null);
    }

    public SessionStore proxy(SessionProxyType type, String host, int port, String username, String password) {
        ProxyHTTP proxy = null;
        if (SessionProxyType.HTTP.equals((Object)type)) {
            proxy = new ProxyHTTP(host, port);
            if (!Strings.isBlank((String)username)) {
                proxy.setUserPasswd(username, password);
            }
        } else if (SessionProxyType.SOCKS4.equals((Object)type)) {
            proxy = new ProxySOCKS4(host, port);
            if (!Strings.isBlank((String)username)) {
                ((ProxySOCKS4)proxy).setUserPasswd(username, password);
            }
        } else if (SessionProxyType.SOCKS5.equals((Object)type)) {
            proxy = new ProxySOCKS5(host, port);
            if (!Strings.isBlank((String)username)) {
                ((ProxySOCKS5)proxy).setUserPasswd(username, password);
            }
        }
        if (proxy != null) {
            this.session.setProxy((Proxy)proxy);
        }
        return this;
    }

    public SessionStore clientVersion(String version) {
        this.session.setClientVersion(version);
        return this;
    }

    public SessionStore daemonThread(boolean daemon) {
        this.session.setDaemonThread(daemon);
        return this;
    }

    public String getConfig(String key) {
        return this.session.getConfig(key);
    }

    public void setConfig(String key, String value) {
        this.session.setConfig(key, value);
    }

    public SessionStore timeout(int timeout) {
        Valid.gte((Comparable)Integer.valueOf(timeout), (Comparable)Integer.valueOf(0), (String)"the time must greater than or equal 0", (Object[])new Object[0]);
        try {
            this.session.setServerAliveInterval(timeout);
            this.session.setServerAliveCountMax(2);
            this.session.setTimeout(timeout);
        }
        catch (Exception e) {
            throw Exceptions.runtime((Throwable)e);
        }
        return this;
    }

    public SessionStore connect() {
        return this.connect(this.session.getTimeout());
    }

    public SessionStore connect(int timeout) {
        try {
            this.session.connect(timeout);
        }
        catch (Exception e) {
            if (Strings.def((String)e.getMessage()).contains(AUTH_FAIL_MESSAGE)) {
                throw Exceptions.authentication((Throwable)e);
            }
            throw Exceptions.connection((Throwable)e);
        }
        return this;
    }

    public CommandExecutor getCommandExecutor(String command) {
        return this.getCommandExecutor(Strings.bytes((String)command, (String)"UTF-8"));
    }

    public CommandExecutor getCommandExecutor(String command, String charset) {
        return this.getCommandExecutor(Strings.bytes((String)command, (String)charset));
    }

    public CommandExecutor getCommandExecutor(byte[] command) {
        try {
            return new CommandExecutor((ChannelExec)this.session.openChannel(COMMAND_TYPE), command);
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public ShellExecutor getShellExecutor() {
        try {
            return new ShellExecutor((ChannelShell)this.session.openChannel(SHELL_TYPE));
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public SftpExecutor getSftpExecutor() {
        return this.getSftpExecutor("UTF-8");
    }

    public SftpExecutor getSftpExecutor(String fileNameCharset) {
        try {
            return new SftpExecutor((ChannelSftp)this.session.openChannel(SFTP_TYPE), fileNameCharset);
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public Session getSession() {
        return this.session;
    }

    public String getHost() {
        return this.session.getHost();
    }

    public void setHost(String host) {
        this.session.setHost(host);
    }

    public int getPort() {
        return this.session.getPort();
    }

    public void setPort(int port) {
        this.session.setPort(port);
    }

    public String getUsername() {
        return this.session.getUserName();
    }

    public void close() {
        if (this.isConnected()) {
            this.disconnect();
        }
    }
}

