/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.ftp.client.pool;

import cn.orionsec.kit.lang.able.SafeCloseable;
import cn.orionsec.kit.lang.utils.Threads;
import cn.orionsec.kit.net.ftp.client.pool.FtpClientPool;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.net.ftp.FTPClient;

public class FtpClientKeepAlive
implements SafeCloseable {
    private final FtpClientPool pool;
    private int heartCheckTime;
    private volatile boolean flag;

    protected FtpClientKeepAlive(FtpClientPool pool) {
        this.pool = pool;
    }

    protected void listener(int heartCheckTime) {
        this.heartCheckTime = heartCheckTime;
        this.flag = true;
        Threads.CACHE_EXECUTOR.execute(new FtpClientKeepAliveListener());
    }

    public void close() {
        this.flag = false;
    }

    private class FtpClientKeepAliveListener
    implements Runnable {
        private FtpClientKeepAliveListener() {
        }

        @Override
        public void run() {
            while (FtpClientKeepAlive.this.flag) {
                BlockingQueue<FTPClient> queue = FtpClientKeepAlive.this.pool.getPool();
                if (queue != null && queue.size() > 0) {
                    Iterator iterator = queue.iterator();
                    while (iterator.hasNext()) {
                        FTPClient q;
                        FTPClient ftpClient = q = (FTPClient)iterator.next();
                        try {
                            if (ftpClient.sendNoOp()) continue;
                            FtpClientKeepAlive.this.pool.invalidClient(ftpClient);
                            FtpClientKeepAlive.this.pool.addClient();
                        }
                        catch (Exception e) {
                            FtpClientKeepAlive.this.pool.invalidClient(ftpClient);
                            FtpClientKeepAlive.this.pool.addClient();
                        }
                    }
                }
                Threads.sleep((long)FtpClientKeepAlive.this.heartCheckTime);
            }
        }
    }
}

