/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.ftp.client.instance;

import cn.orionsec.kit.lang.define.StreamEntry;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.net.ftp.client.FtpFile;
import cn.orionsec.kit.net.ftp.client.FtpMessage;
import cn.orionsec.kit.net.ftp.client.Ftps;
import cn.orionsec.kit.net.ftp.client.config.FtpConfig;
import cn.orionsec.kit.net.ftp.client.instance.IFtpInstance;
import cn.orionsec.kit.net.ftp.client.pool.FtpClientPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public abstract class BaseFtpInstance
implements IFtpInstance {
    protected static final String SEPARATOR = "/";
    protected FTPClient client;
    protected FtpConfig config;
    protected FtpClientPool pool;
    protected int bufferSize;

    public BaseFtpInstance(FtpClientPool pool) {
        this.pool = pool;
        this.client = pool.getClient();
        this.config = pool.getConfig();
        this.bufferSize = 8192;
    }

    public BaseFtpInstance(FTPClient client, FtpConfig config) {
        this.client = client;
        this.config = config;
        this.bufferSize = 8192;
    }

    @Override
    public int replyCode() {
        return this.client.getReplyCode();
    }

    @Override
    public String replyMsg() {
        return FtpMessage.REPLY_CODE.get(this.client.getReplyCode());
    }

    @Override
    public boolean reply() {
        return FTPReply.isPositiveCompletion((int)this.client.getReplyCode());
    }

    @Override
    public long transfer(String path, String file, long skip, int size) throws IOException {
        return this.doTransfer(path, Files1.openOutputStreamFast((String)file), skip, size, true);
    }

    @Override
    public long transfer(String path, OutputStream out, long skip, int size) throws IOException {
        return this.doTransfer(path, out, skip, size, false);
    }

    protected abstract long doTransfer(String var1, OutputStream var2, long var3, int var5, boolean var6) throws IOException;

    @Override
    public void write(String path, InputStream in) throws IOException {
        this.doWrite(path, in, null);
    }

    @Override
    public void write(String path, byte[] bs, int off, int len) throws IOException {
        this.doWrite(path, null, new StreamEntry(bs, off, len));
    }

    protected abstract void doWrite(String var1, InputStream var2, StreamEntry var3) throws IOException;

    @Override
    public void append(String path, InputStream in) throws IOException {
        this.doAppend(path, in, null);
    }

    @Override
    public void append(String path, byte[] bs, int off, int len) throws IOException {
        this.doAppend(path, null, new StreamEntry(bs, off, len));
    }

    protected abstract void doAppend(String var1, InputStream var2, StreamEntry var3) throws IOException;

    @Override
    public void uploadFile(String remoteFile, String localFile) throws IOException {
        this.uploadFile(remoteFile, Files1.openInputStreamSafe((String)localFile), true);
    }

    @Override
    public void downloadFile(String remoteFile, String localFile) throws IOException {
        this.downloadFile(remoteFile, Files1.openOutputStreamFast((String)localFile), true);
    }

    @Override
    public List<FtpFile> listFiles(String path, boolean child, boolean dir) {
        String base = this.config.getRemoteRootDir();
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles(this.serverCharset(base + path))) {
                String t = this.serverCharset(Files1.getPath((String)path, (String)file.getName()));
                if (file.isFile()) {
                    list.add(new FtpFile(t, file));
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (dir) {
                    list.add(new FtpFile(t, file));
                }
                if (!child) continue;
                list.addAll(this.listFiles(t + SEPARATOR, true, dir));
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
        return list;
    }

    @Override
    public List<FtpFile> listDirs(String path, boolean child) {
        String base = this.config.getRemoteRootDir();
        ArrayList<FtpFile> list = new ArrayList<FtpFile>();
        try {
            FTPFile[] files;
            for (FTPFile file : files = this.client.listFiles(this.serverCharset(base + path))) {
                String t = Files1.getPath((String)path, (String)file.getName());
                if (!file.isDirectory()) continue;
                list.add(new FtpFile(t, file));
                if (!child) continue;
                list.addAll(this.listDirs(Files1.getPath((String)(t + SEPARATOR)), true));
            }
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
        return list;
    }

    @Override
    public boolean pending() throws IOException {
        return this.client.completePendingCommand();
    }

    @Override
    public void restartOffset(long offset) {
        this.client.setRestartOffset(offset);
    }

    @Override
    public void reset() {
        this.client.setRestartOffset(0L);
    }

    @Override
    public String getSystemType() {
        try {
            return this.client.getSystemType();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public String getStatus() {
        try {
            return this.client.getStatus();
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public String getStatus(String path) {
        try {
            return this.client.getStatus(new String(Strings.bytes((String)Files1.getPath((String)this.config.getRemoteRootDir(), (String)path)), this.config.getRemoteFileNameCharset()));
        }
        catch (IOException e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    @Override
    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public FtpConfig getConfig() {
        return this.config;
    }

    @Override
    public FtpClientPool getPool() {
        return this.pool;
    }

    @Override
    public boolean sendNoop() throws IOException {
        return this.client.sendNoOp();
    }

    @Override
    public String serverCharset(String chars) {
        return new String(Strings.bytes((String)Files1.getPath((String)chars)), this.config.getRemoteFileNameCharset());
    }

    @Override
    public String localCharset(String chars) {
        return new String(Strings.bytes((String)Files1.getPath((String)chars)), this.config.getLocalFileNameCharset());
    }

    public void destroy() {
        Ftps.destroy(this.client);
    }

    public void close() {
        if (this.pool != null) {
            this.pool.returnClient(this.client);
        } else {
            Ftps.destroy(this.client);
        }
    }
}

