/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.ftp.client;

import cn.orionsec.kit.net.ftp.client.config.FtpConfig;
import cn.orionsec.kit.net.ftp.client.instance.IFtpInstance;
import cn.orionsec.kit.net.ftp.client.pool.FtpClientFactory;
import cn.orionsec.kit.net.ftp.client.pool.FtpClientPool;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ftps {
    private static final Logger LOGGER = LoggerFactory.getLogger(Ftps.class);

    private Ftps() {
    }

    public static void destroy(FTPClient client) {
        if (client != null && client.isConnected()) {
            try {
                client.logout();
            }
            catch (Exception e) {
                LOGGER.error("Ftps.destroy logout error", (Throwable)e);
            }
            finally {
                try {
                    client.disconnect();
                }
                catch (Exception e) {
                    LOGGER.error("Ftps.destroy disconnect error", (Throwable)e);
                }
            }
        }
    }

    public static boolean isActive(FTPClient client) {
        if (client != null && client.isConnected()) {
            try {
                return client.sendNoOp();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static IFtpInstance createInstance(FtpConfig ftpConfig) {
        return new FtpClientFactory(ftpConfig).createInstance();
    }

    public static FtpClientPool createClientPool(FtpConfig ftpConfig) {
        return new FtpClientPool(new FtpClientFactory(ftpConfig));
    }

    public static FtpClientPool createClientPool(FtpConfig ftpConfig, int size) {
        return new FtpClientPool(new FtpClientFactory(ftpConfig), size);
    }
}

