/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.net.ftp.client;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.net.ftp.FTPFile;

public class FtpFile
implements Serializable {
    private static final long serialVersionUID = -8231234702679455L;
    private final FTPFile ftpFile;
    private String path;
    private String name;
    private long size;
    private int type;
    private String user;
    private String group;
    private String link;
    private int hardLinkCount;
    private Date modifyTime;
    private String rawListing;
    private boolean[] permission;
    private String permissionString;

    public FtpFile(String path, FTPFile ftpFile) {
        this.ftpFile = ftpFile;
        this.path = path;
        this.name = ftpFile.getName();
        this.size = ftpFile.getSize();
        this.type = ftpFile.getType();
        this.user = ftpFile.getUser();
        this.group = ftpFile.getGroup();
        this.link = ftpFile.getLink();
        this.hardLinkCount = ftpFile.getHardLinkCount();
        this.modifyTime = ftpFile.getTimestamp().getTime();
        this.rawListing = ftpFile.getRawListing();
        this.permissionString = this.rawListing.split(" ")[0];
        this.permission = new boolean[9];
        this.permission[0] = ftpFile.hasPermission(0, 0);
        this.permission[1] = ftpFile.hasPermission(0, 1);
        this.permission[2] = ftpFile.hasPermission(0, 2);
        this.permission[3] = ftpFile.hasPermission(1, 0);
        this.permission[4] = ftpFile.hasPermission(1, 1);
        this.permission[5] = ftpFile.hasPermission(1, 2);
        this.permission[6] = ftpFile.hasPermission(2, 0);
        this.permission[7] = ftpFile.hasPermission(2, 1);
        this.permission[8] = ftpFile.hasPermission(2, 2);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getHardLinkCount() {
        return this.hardLinkCount;
    }

    public void setHardLinkCount(int hardLinkCount) {
        this.hardLinkCount = hardLinkCount;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getRawListing() {
        return this.rawListing;
    }

    public void setRawListing(String rawListing) {
        this.rawListing = rawListing;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public boolean[] getPermission() {
        return this.permission;
    }

    public void setPermission(boolean[] permission) {
        this.permission = permission;
    }

    public void setPermissionString(String permissionString) {
        this.permissionString = permissionString;
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public FTPFile getFtpFile() {
        return this.ftpFile;
    }

    public boolean isFile() {
        return this.type == 0;
    }

    public boolean isDirectory() {
        return this.type == 1;
    }

    public boolean isSymbolicLink() {
        return this.type == 2;
    }

    public boolean isUnknown() {
        return this.type == 3;
    }

    public String toString() {
        return this.path;
    }
}

