/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.kafka.spring.boot.autoconfigure.reply;

import cn.org.faster.framework.kafka.spring.boot.autoconfigure.KafkaProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.kafka.requestreply.ReplyingKafkaTemplate;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;

@ConditionalOnProperty(prefix="app.kafka.producer", name={"reply"}, havingValue="true")
public class ReplyConfiguration {
    private final KafkaProperties properties;
    private final org.springframework.boot.autoconfigure.kafka.KafkaProperties kafkaProperties;
    private final RecordMessageConverter messageConverter;
    private final ConsumerFactory<Object, Object> consumerFactory;
    private final ProducerFactory<Object, Object> producerFactory;
    private final ProducerListener<Object, Object> producerListener;

    public ReplyConfiguration(KafkaProperties properties, org.springframework.boot.autoconfigure.kafka.KafkaProperties kafkaProperties, ObjectProvider<RecordMessageConverter> messageConverter, ConsumerFactory<Object, Object> consumerFactory, ProducerFactory<Object, Object> producerFactory, ProducerListener<Object, Object> producerListener) {
        this.kafkaProperties = kafkaProperties;
        this.properties = properties;
        this.messageConverter = (RecordMessageConverter)messageConverter.getIfUnique();
        this.consumerFactory = consumerFactory;
        this.producerFactory = producerFactory;
        this.producerListener = producerListener;
    }

    public KafkaMessageListenerContainer<Object, Object> replyContainer() {
        ContainerProperties containerProperties = new ContainerProperties(new String[]{this.properties.getProducer().getReplyTopic()});
        return new KafkaMessageListenerContainer(this.consumerFactory, containerProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReplyingKafkaTemplate<?, ?, ?> replyingKafkaTemplate() {
        ReplyingKafkaTemplate kafkaTemplate = new ReplyingKafkaTemplate(this.producerFactory, this.replyContainer());
        if (this.messageConverter != null) {
            kafkaTemplate.setMessageConverter(this.messageConverter);
        }
        kafkaTemplate.setProducerListener(this.producerListener);
        kafkaTemplate.setDefaultTopic(this.kafkaProperties.getTemplate().getDefaultTopic());
        return kafkaTemplate;
    }
}

