/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.kafka.spring.boot.autoconfigure.error;

import cn.org.faster.framework.kafka.error.deadLetter.KafkaDeadLetterBatchErrorHandler;
import cn.org.faster.framework.kafka.error.deadLetter.KafkaDeadLetterErrorHandler;
import cn.org.faster.framework.kafka.error.normal.KafkaBatchErrorHandler;
import cn.org.faster.framework.kafka.error.normal.KafkaErrorHandler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;

@ConditionalOnProperty(prefix="app.kafka.error", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ErrorConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="app.kafka.error", name={"dead-letter"}, havingValue="true")
    @ConditionalOnMissingBean
    public GenericErrorHandler kafkaDeadLetterBatchErrorHandler(KafkaTemplate<Object, Object> kafkaTemplate, ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory) {
        if (concurrentKafkaListenerContainerFactory.isBatchListener() != null && concurrentKafkaListenerContainerFactory.isBatchListener().booleanValue()) {
            KafkaDeadLetterBatchErrorHandler batchErrorHandler = new KafkaDeadLetterBatchErrorHandler(kafkaTemplate);
            concurrentKafkaListenerContainerFactory.setBatchErrorHandler((BatchErrorHandler)batchErrorHandler);
            return batchErrorHandler;
        }
        KafkaDeadLetterErrorHandler errorHandler = new KafkaDeadLetterErrorHandler(kafkaTemplate);
        concurrentKafkaListenerContainerFactory.setErrorHandler((ErrorHandler)errorHandler);
        return errorHandler;
    }

    @Bean
    @ConditionalOnMissingBean
    public GenericErrorHandler kafkaBatchErrorHandler(ConcurrentKafkaListenerContainerFactory concurrentKafkaListenerContainerFactory) {
        if (concurrentKafkaListenerContainerFactory.isBatchListener() != null && concurrentKafkaListenerContainerFactory.isBatchListener().booleanValue()) {
            KafkaBatchErrorHandler batchErrorHandler = new KafkaBatchErrorHandler();
            concurrentKafkaListenerContainerFactory.setBatchErrorHandler((BatchErrorHandler)batchErrorHandler);
            return batchErrorHandler;
        }
        KafkaErrorHandler errorHandler = new KafkaErrorHandler();
        concurrentKafkaListenerContainerFactory.setErrorHandler((ErrorHandler)errorHandler);
        return errorHandler;
    }
}

