/*
 * Decompiled with CFR 0.152.
 */
package cn.org.faster.framework.kafka.error.deadLetter;

import cn.org.faster.framework.kafka.error.log.KafkaLoggingErrorHandler;
import java.util.List;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;

public class KafkaDeadLetterBatchErrorHandler
implements BatchErrorHandler,
KafkaLoggingErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(KafkaDeadLetterBatchErrorHandler.class);
    private final DeadLetterPublishingRecoverer deadLetterPublishingRecoverer;

    public KafkaDeadLetterBatchErrorHandler(KafkaTemplate<Object, Object> kafkaTemplate) {
        this.deadLetterPublishingRecoverer = new DeadLetterPublishingRecoverer(kafkaTemplate);
    }

    public void handle(Exception thrownException, ConsumerRecords<?, ?> data) {
        thrownException.printStackTrace();
        log.error(this.handleLogMessage(thrownException));
        if (thrownException.getCause() instanceof MethodArgumentNotValidException) {
            return;
        }
        Set topicPartitions = data.partitions();
        log.error("send failed message to dead letter");
        for (TopicPartition topicPartition : topicPartitions) {
            List list = data.records(topicPartition);
            for (ConsumerRecord consumerRecord : list) {
                this.deadLetterPublishingRecoverer.accept(consumerRecord, thrownException);
            }
        }
        log.error("send failed message to dead letter successful");
    }
}

