/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.qiniu;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BatchStatus;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FetchRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.Etag;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUpload {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUpload.class);
    public static Region huaDong = Region.region0();
    public static Region huaBei = Region.region1();
    public static Region huaNan = Region.region2();
    public static Region beiMei = Region.regionNa0();
    public static Region xinJiaPo = Region.regionAs0();
    public static String accessKey;
    public static String secretKey;
    public static String bucket;
    public static Region region;

    private static UploadManager buildUploadManager(Region region) {
        Configuration configuration = (Configuration)Singleton.get(Configuration.class, (Object[])new Object[]{region});
        return (UploadManager)Singleton.get(UploadManager.class, (Object[])new Object[]{configuration});
    }

    public static BucketManager getBucketManager(Region region) {
        return (BucketManager)Singleton.get(BucketManager.class, (Object[])new Object[]{Auth.create((String)accessKey, (String)secretKey), Singleton.get(Configuration.class, (Object[])new Object[]{region})});
    }

    private static DefaultPutRet putRet(Response response) throws QiniuException {
        DefaultPutRet putRet = (DefaultPutRet)JSON.parseObject((String)response.bodyString(), DefaultPutRet.class);
        if (StringUtils.isNullOrEmpty((String)putRet.key) || StringUtils.isNullOrEmpty((String)putRet.hash)) {
            return null;
        }
        return putRet;
    }

    public static DefaultPutRet uploader(File cosFile, String key, String upToken, Region region) throws QiniuException {
        if (cosFile == null) {
            return null;
        }
        return QiNiuUpload.putRet(QiNiuUpload.buildUploadManager(region).put(cosFile, key, upToken));
    }

    public static DefaultPutRet uploader(File cosFile, String key) throws QiniuException {
        return QiNiuUpload.uploader(cosFile, key, QiNiuUpload.getUploadToken(), region);
    }

    public static DefaultPutRet uploader(InputStream cosFile, String key, String upToken, Region region) throws QiniuException {
        if (cosFile == null) {
            return null;
        }
        return QiNiuUpload.putRet(QiNiuUpload.buildUploadManager(region).put(cosFile, key, upToken, null, null));
    }

    public static DefaultPutRet uploader(InputStream cosFile, String key) throws QiniuException {
        return QiNiuUpload.uploader(cosFile, key, QiNiuUpload.getUploadToken(), region);
    }

    public static DefaultPutRet stringUploader(String key, String upToken, Region region, String str, String charsetName) throws QiniuException {
        if (org.apache.commons.lang.StringUtils.isBlank((String)str)) {
            return null;
        }
        ByteArrayInputStream inputStream = IoUtil.toStream((String)str, (String)charsetName);
        return QiNiuUpload.uploader(inputStream, key, upToken, region);
    }

    public static DefaultPutRet stringUploader(String key, String str, String charsetName) throws QiniuException {
        return QiNiuUpload.stringUploader(key, QiNiuUpload.getUploadToken(), region, str, charsetName);
    }

    public static DefaultPutRet stringUploader(String key, String upToken, Region region, String str) throws QiniuException {
        return QiNiuUpload.stringUploader(key, upToken, region, str, "UTF-8");
    }

    public static DefaultPutRet stringUploader(String key, String str) throws QiniuException {
        return QiNiuUpload.stringUploader(key, QiNiuUpload.getUploadToken(), region, str);
    }

    public static String downloadString(String url, String customCharsetName) {
        return HttpUtil.downloadString((String)url, (String)customCharsetName);
    }

    public static DefaultPutRet uploader(byte[] uploadBytes, String key, String upToken, Region region) throws QiniuException {
        if (uploadBytes == null) {
            return null;
        }
        return QiNiuUpload.putRet(QiNiuUpload.buildUploadManager(region).put(uploadBytes, key, upToken));
    }

    public static DefaultPutRet uploader(byte[] uploadBytes, String key) throws QiniuException {
        return QiNiuUpload.uploader(uploadBytes, key, QiNiuUpload.getUploadToken(), region);
    }

    public static void uploader(byte[] data, String key, String token, StringMap params, String mime, boolean checkCrc, UpCompletionHandler handler, Region region) throws IOException {
        QiNiuUpload.buildUploadManager(region).asyncPut(data, key, token, params, mime, checkCrc, handler);
    }

    public static void uploader(byte[] data, String key, StringMap params, String mime, boolean checkCrc, UpCompletionHandler handler) throws IOException {
        QiNiuUpload.uploader(data, key, QiNiuUpload.getUploadToken(), params, mime, checkCrc, handler, region);
    }

    public static void uploader(byte[] data, String key, String token, UpCompletionHandler handler, Region region) throws IOException {
        QiNiuUpload.buildUploadManager(region).asyncPut(data, key, token, null, null, false, handler);
    }

    public static void uploader(byte[] data, String key, UpCompletionHandler handler) throws IOException {
        QiNiuUpload.uploader(data, key, QiNiuUpload.getUploadToken(), handler, region);
    }

    public static FileInfo getFileInfo(String key, Region region) throws QiniuException {
        return QiNiuUpload.getBucketManager(region).stat(bucket, key);
    }

    public static FileInfo getFileInfo(String key) throws QiniuException {
        return QiNiuUpload.getFileInfo(key, region);
    }

    public static Response setFileType(String key, Region region, String newMimeType) throws QiniuException {
        return QiNiuUpload.getBucketManager(region).changeMime(bucket, key, newMimeType);
    }

    public static Response setFileType(String key, String newMimeType) throws QiniuException {
        return QiNiuUpload.setFileType(key, region, newMimeType);
    }

    public static String getPrivateDownloadUrl(String publicUrl, long expireInSeconds) {
        return Auth.create((String)accessKey, (String)secretKey).privateDownloadUrl(publicUrl, expireInSeconds);
    }

    public static BucketManager.FileListIterator getFilesList(String prefix, int limit, String delimiter, Region region) {
        BucketManager bucketManager = QiNiuUpload.getBucketManager(region);
        return bucketManager.createFileListIterator(bucket, prefix, limit, delimiter);
    }

    public static BucketManager.FileListIterator getFilesList(String prefix, int limit, String delimiter) {
        return QiNiuUpload.getFilesList(prefix, limit, delimiter, region);
    }

    public static FetchRet fetch(String remoteSrcUrl, String key, Region region) throws QiniuException {
        return QiNiuUpload.getBucketManager(region).fetch(remoteSrcUrl, bucket, key);
    }

    public static FetchRet fetch(String remoteSrcUrl, String key) throws QiniuException {
        return QiNiuUpload.fetch(remoteSrcUrl, key, region);
    }

    public static Response delete(String key, Region region) throws QiniuException {
        return QiNiuUpload.getBucketManager(region).delete(bucket, key);
    }

    public static Response delete(String key) throws QiniuException {
        return QiNiuUpload.delete(key, region);
    }

    public static BatchStatus[] delete(String[] keyList, Region region) throws QiniuException {
        BucketManager bucketManager = QiNiuUpload.getBucketManager(region);
        BucketManager.BatchOperations batchOperations = new BucketManager.BatchOperations();
        batchOperations.addDeleteOp(bucket, keyList);
        Response response = bucketManager.batch(batchOperations);
        return (BatchStatus[])response.jsonToObject(BatchStatus[].class);
    }

    public static BatchStatus[] delete(String[] keyList) throws QiniuException {
        return QiNiuUpload.delete(keyList, region);
    }

    public static String getUploadToken() {
        return Auth.create((String)accessKey, (String)secretKey).uploadToken(bucket);
    }

    public static String getUploadToken(String key) {
        return Auth.create((String)accessKey, (String)secretKey).uploadToken(bucket, key);
    }

    public static String getUploadToken(long expires) {
        return Auth.create((String)accessKey, (String)secretKey).uploadToken(bucket, null, expires, null, true);
    }

    public static String getUploadToken(String key, long expires) {
        return Auth.create((String)accessKey, (String)secretKey).uploadToken(bucket, key, expires, null, true);
    }

    public static String getEtag(InputStream in, long len) throws IOException {
        return Etag.stream((InputStream)in, (long)len);
    }

    public static String getEtag(byte[] data, int offset, int length) {
        return Etag.data((byte[])data, (int)offset, (int)length);
    }

    public static String getEtag(byte[] data) {
        return Etag.data((byte[])data);
    }

    public static String getEtag(File file) throws IOException {
        return Etag.file((File)file);
    }

    public static String getEtag(String filePath) throws IOException {
        return Etag.file((String)filePath);
    }

    static {
        region = huaDong;
    }
}

