/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.utils;

import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionsUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionsUtils.class);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";

    private static RuntimeException convertReflectionExceptionToUnchecked(Throwable e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private static void makeAccessible(Method method) {
        boolean isTrue;
        boolean bl = isTrue = (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) && !method.isAccessible();
        if (isTrue) {
            method.setAccessible(true);
        }
    }

    private static void makeAccessible(Field field) {
        boolean isTrue;
        boolean bl = isTrue = (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers()) || Modifier.isFinal(field.getModifiers())) && !field.isAccessible();
        if (isTrue) {
            field.setAccessible(true);
        }
    }

    private static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        Class<?> searchType = obj.getClass();
        while (searchType != Object.class) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                if (method == null) continue;
                ReflectionsUtils.makeAccessible(method);
                return method;
            }
            catch (Throwable e) {
                log.error("getAccessibleMethod-\u53cd\u5c04\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u65b9\u6cd5", e);
                searchType = searchType.getSuperclass();
            }
        }
        return null;
    }

    private static Method getAccessibleMethodByName(Object obj, String methodName) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionsUtils.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    private static Field getAccessibleField(Object obj, String fieldName) {
        Class<?> superClass = obj.getClass();
        while (superClass != Object.class) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                if (field == null) continue;
                ReflectionsUtils.makeAccessible(field);
                return field;
            }
            catch (Throwable e) {
                log.error("getAccessibleField-\u53cd\u5c04\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5b57\u6bb5", e);
                superClass = superClass.getSuperclass();
            }
        }
        return null;
    }

    private static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionsUtils.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("invokeMethod-\u5728\u5bf9\u8c61[" + obj + "]\u4e2d\u627e\u4e0d\u5230\u65b9\u6cd5 [" + methodName + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            log.error("invokeMethod-\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u5931\u8d25", (Throwable)e);
            throw ReflectionsUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    private static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionsUtils.getAccessibleMethodByName(obj, methodName);
        if (method == null) {
            throw new IllegalArgumentException("invokeMethod-\u5728\u5bf9\u8c61[" + obj + "]\u4e2d\u627e\u4e0d\u5230\u65b9\u6cd5 [" + methodName + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            log.error("invokeMethodByName-\u53cd\u5c04\u8c03\u7528\u65b9\u6cd5\u5931\u8d25", (Throwable)e);
            throw ReflectionsUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeGetter(Object obj, String propertyName) {
        String[] propertyArray;
        Object object = obj;
        for (String name : propertyArray = StringUtils.split((String)propertyName, (String)".")) {
            String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)name);
            object = ReflectionsUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Object object = obj;
        String[] names = StringUtils.split((String)propertyName, (String)".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)names[i]);
                object = ReflectionsUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)names[i]);
            ReflectionsUtils.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Object result;
        Field field = ReflectionsUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("getFieldValue-\u5728\u5bf9\u8c61[" + obj + "]\u4e2d\u627e\u4e0d\u5230\u5b57\u6bb5[" + fieldName + "]");
        }
        try {
            result = field.get(obj);
        }
        catch (Throwable e) {
            log.error("getFieldValue-\u901a\u8fc7\u53cd\u5c04\u76f4\u63a5\u8bfb\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c\u5931\u8d25", e);
            throw ReflectionsUtils.convertReflectionExceptionToUnchecked(e);
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionsUtils.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("getFieldValue-\u5728\u5bf9\u8c61[" + obj + "]\u4e2d\u627e\u4e0d\u5230\u5b57\u6bb5[" + fieldName + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (Throwable e) {
            log.error("getFieldValue-\u901a\u8fc7\u53cd\u5c04\u76f4\u63a5\u8bbe\u7f6e\u5bf9\u8c61\u5c5e\u6027\u503c", e);
            throw ReflectionsUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    private static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(clazz.getSimpleName() + "\u7c7b\u4e0d\u662fParameterizedType\u7684\u5b50\u7c7b");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            Type type;
            if (params[index] instanceof ParameterizedType && (type = ((ParameterizedType)params[index]).getRawType()) instanceof Class) {
                return (Class)type;
            }
            Log.debug(clazz.getSimpleName() + "\u6ca1\u6709\u8bbe\u7f6e\u8d85\u6cdb\u578b\u53c2\u6570\u7684\u5b9e\u9645\u7c7b", new Object[0]);
            return Object.class;
        }
        return (Class)params[index];
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectionsUtils.getClassGenricType(clazz, 0);
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }
}

