/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoUtils {
    private static final Logger log = LoggerFactory.getLogger(IoUtils.class);
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            log.error("\u6570\u636e\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)ioe);
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IoUtils.closeQuietly(closeable);
        }
    }

    private static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IoUtils.copy(input, output, 4096);
    }

    private static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return IoUtils.copyLarge(input, output, new byte[bufferSize]);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IoUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IoUtils.copy(input, output);
        return output.toByteArray();
    }
}

