/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.utils;

import cn.hutool.core.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class IniFileReader {
    private Hashtable paramTable;
    private String confFilename;

    public IniFileReader(String confFilename) {
        this.confFilename = confFilename;
        this.loadFromFile(confFilename);
    }

    public static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static InputStream loadFromOsFileSystemOrClasspathAsStream(String filePath) {
        InputStream in = null;
        try {
            in = new File(filePath).exists() ? new FileInputStream(filePath) : IniFileReader.classLoader().getResourceAsStream(filePath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return in;
    }

    public String getConfFilename() {
        return this.confFilename;
    }

    public String getStrValue(String name) {
        Object obj = this.paramTable.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return (String)((ArrayList)obj).get(0);
    }

    public int getIntValue(String name, int defaultValue) {
        String szValue = this.getStrValue(name);
        if (szValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(szValue);
    }

    public boolean getBoolValue(String name, boolean defaultValue) {
        String szValue = this.getStrValue(name);
        if (szValue == null) {
            return defaultValue;
        }
        Object[] str = new String[]{"yes", "on", "true", "1"};
        return ArrayUtil.contains((Object[])str, (Object)szValue);
    }

    public String[] getValues(String name) {
        Object obj = this.paramTable.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String[] values = new String[]{(String)obj};
            return values;
        }
        Object[] objs = ((ArrayList)obj).toArray();
        String[] values = new String[objs.length];
        System.arraycopy(objs, 0, values, 0, objs.length);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromFile(String confFilePath) {
        InputStream in = IniFileReader.loadFromOsFileSystemOrClasspathAsStream(confFilePath);
        try {
            this.readToParamTable(in);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readToParamTable(InputStream in) {
        this.paramTable = new Hashtable();
        if (in == null) {
            return;
        }
        InputStreamReader inReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            inReader = new InputStreamReader(in);
            bufferedReader = new BufferedReader(inReader);
            while ((line = bufferedReader.readLine()) != null) {
                ArrayList<Object> valueList;
                String[] parts;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || (parts = line.split("=", 2)).length != 2) continue;
                String name = parts[0].trim();
                String value = parts[1].trim();
                Object obj = this.paramTable.get(name);
                if (obj == null) {
                    this.paramTable.put(name, value);
                    continue;
                }
                if (obj instanceof String) {
                    valueList = new ArrayList<Object>();
                    valueList.add(obj);
                    valueList.add(value);
                    this.paramTable.put(name, valueList);
                    continue;
                }
                valueList = (ArrayList<Object>)obj;
                valueList.add(value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

