/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol.storage.request;

import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseRequest;
import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import java.nio.charset.Charset;

public class TruncateRequest
extends BaseRequest {
    @FastDfsColumn(index=0)
    private long pathSize;
    @FastDfsColumn(index=1)
    private long fileSize;
    @FastDfsColumn(index=2, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public TruncateRequest(String path, long fileSize) {
        this.fileSize = fileSize;
        this.path = path;
        this.head = new ProtocolHead(36);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.pathSize = this.path.getBytes(charset).length;
        return super.encodeParam(charset);
    }

    public long getPathSize() {
        return this.pathSize;
    }

    public void setPathSize(long pathSize) {
        this.pathSize = pathSize;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    public String toString() {
        return "TruncateRequest [pathSize=" + this.pathSize + ", fileSize=" + this.fileSize + ", path=" + this.path + "]";
    }
}

