/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.protocol.storage.request;

import cn.novelweb.tool.upload.fastdfs.mapper.DynamicFieldType;
import cn.novelweb.tool.upload.fastdfs.mapper.FastDfsColumn;
import cn.novelweb.tool.upload.fastdfs.protocol.BaseRequest;
import cn.novelweb.tool.upload.fastdfs.protocol.ProtocolHead;
import java.io.InputStream;
import java.nio.charset.Charset;

public class ModifyRequest
extends BaseRequest {
    @FastDfsColumn(index=0)
    private long pathSize;
    @FastDfsColumn(index=1)
    private long fileOffset;
    @FastDfsColumn(index=2)
    private long fileSize;
    @FastDfsColumn(index=3, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public ModifyRequest(InputStream inputStream, long fileSize, String path, long fileOffset) {
        this.inputFile = inputStream;
        this.fileSize = fileSize;
        this.path = path;
        this.fileOffset = fileOffset;
        this.head = new ProtocolHead(34);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.pathSize = this.path.getBytes(charset).length;
        return super.encodeParam(charset);
    }

    public long getPathSize() {
        return this.pathSize;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }
}

