/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.pool;

import cn.novelweb.tool.upload.fastdfs.exception.FastDfsUnavailableException;
import cn.novelweb.tool.upload.fastdfs.pool.CircularList;
import cn.novelweb.tool.upload.fastdfs.pool.TrackerAddressState;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerLocator {
    private static final Logger log = LoggerFactory.getLogger(TrackerLocator.class);
    private static final int DEFAULT_RETRY_AFTER_SECOND = 600;
    private int retryAfterSecond = 600;
    private Map<String, TrackerAddressState> trackerAddressMap = new HashMap<String, TrackerAddressState>();
    private CircularList<TrackerAddressState> trackerAddressCircular = new CircularList();

    public TrackerLocator(Set<String> trackerSet) {
        Log.debug("\u5f00\u59cb\u521d\u59cb\u5316Tracker Server\u5730\u5740:{}", trackerSet);
        for (String addressStr : trackerSet) {
            InetSocketAddress address;
            if (StringUtils.isBlank((String)addressStr)) continue;
            String[] parts = StringUtils.split((String)addressStr, (String)":", (int)2);
            if (parts.length != 2) {
                log.warn("Tracker Server\u5730\u5740\u683c\u5f0f\u65e0\u6548[{}], \u8df3\u8fc7\u6b64\u914d\u7f6e(\u6b63\u786e\u683c\u5f0f host:port)", (Object)addressStr);
                continue;
            }
            try {
                address = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
            }
            catch (Throwable e) {
                log.warn("\u521b\u5efaInetSocketAddress\u5931\u8d25, Tracker Server\u5730\u5740[{}], \u8df3\u8fc7\u6b64\u914d\u7f6e", (Object)addressStr);
                continue;
            }
            if (this.trackerAddressMap.get(addressStr) != null) continue;
            TrackerAddressState holder = new TrackerAddressState(address);
            this.trackerAddressCircular.add(holder);
            this.trackerAddressMap.put(address.toString(), holder);
        }
        if (log.isDebugEnabled()) {
            String tmp = "\r\n#=======================================================================================================================#\r\n# \u521d\u59cb\u5316Tracker Server\u5730\u5740\u5b8c\u6bd5\r\n#\t trackerAddressMap#keySet: " + this.trackerAddressMap.keySet() + "\r\n#\t trackerAddressCircular: " + this.trackerAddressCircular + "\r\n#=======================================================================================================================#\r\n";
            Log.debug(tmp, new Object[0]);
        }
    }

    public InetSocketAddress getTrackerAddress() {
        for (int i = 0; i < this.trackerAddressCircular.size(); ++i) {
            TrackerAddressState holder = this.trackerAddressCircular.next();
            if (!holder.canTryToConnect(this.retryAfterSecond)) continue;
            return holder.getAddress();
        }
        throw new FastDfsUnavailableException("\u627e\u4e0d\u5230\u53ef\u7528\u7684 Tracker Server - {}" + this.trackerAddressMap.keySet());
    }

    public void setActive(InetSocketAddress address, boolean available) {
        TrackerAddressState holder = this.trackerAddressMap.get(address.toString());
        if (holder == null) {
            Log.debug("TrackerAddressMap\u83b7\u53d6TrackerAddressState\u4e3anull, key={}, \u8bbe\u7f6e\u8fde\u63a5\u662f\u5426\u6709\u6548\u5931\u8d25[{}]", (Object)address, (Object)available);
            return;
        }
        holder.setAvailable(available);
    }

    public void setRetryAfterSecond(int retryAfterSecond) {
        this.retryAfterSecond = retryAfterSecond;
    }
}

