/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.pool;

import java.net.InetSocketAddress;

public class TrackerAddressState {
    private InetSocketAddress address;
    private boolean available;
    private long lastUnavailableTime;

    public TrackerAddressState(InetSocketAddress address) {
        this.address = address;
        this.available = true;
    }

    public boolean canTryToConnect(int retryAfterSecond) {
        return this.available || System.currentTimeMillis() - this.lastUnavailableTime > (long)(retryAfterSecond * 1000);
    }

    public void setAvailable(boolean available) {
        this.available = available;
        if (!available) {
            this.lastUnavailableTime = System.currentTimeMillis();
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public long getLastUnavailableTime() {
        return this.lastUnavailableTime;
    }

    public String toString() {
        return "TrackerAddressState{address=" + this.address + ", available=" + this.available + ", lastUnavailableTime=" + this.lastUnavailableTime + '}';
    }
}

