/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.conn;

import cn.novelweb.tool.upload.fastdfs.conn.Connection;
import cn.novelweb.tool.upload.fastdfs.exception.FastDfsConnectException;
import cn.novelweb.tool.upload.fastdfs.utils.BytesUtil;
import cn.novelweb.tool.upload.fastdfs.utils.IoUtils;
import cn.novelweb.tool.upload.fastdfs.utils.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(SocketConnection.class);
    private Socket socket;
    private Charset charset;

    public SocketConnection(InetSocketAddress address, int soTimeout, int connectTimeout, Charset charset) {
        try {
            this.socket = new Socket();
            this.socket.setSoTimeout(soTimeout);
            Log.debug("\u5f00\u59cb\u8fde\u63a5\u5230\u670d\u52a1\u5668 {} soTimeout={} connectTimeout={}", address, soTimeout, connectTimeout);
            this.charset = charset;
            this.socket.connect(address, connectTimeout);
            Log.debug("\u6210\u529f\u8fde\u63a5\u5230\u670d\u52a1\u5668:{}", (Object)address);
        }
        catch (IOException e) {
            throw new FastDfsConnectException("\u4e0d\u80fd\u8fde\u63a5\u5230\u670d\u52a1\u5668:" + address, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        Log.debug("\u65ad\u5f00\u8fde\u63a5, \u670d\u52a1\u5668\u5730\u5740:{}", (Object)this.socket);
        byte[] header = new byte[10];
        Arrays.fill(header, (byte)0);
        byte[] hexLen = BytesUtil.long2buff(0L);
        System.arraycopy(hexLen, 0, header, 0, hexLen.length);
        header[8] = 82;
        header[9] = 0;
        try {
            this.socket.getOutputStream().write(header);
            this.socket.close();
        }
        catch (IOException e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
        finally {
            IoUtils.closeQuietly((Closeable)this.socket);
        }
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isValid() {
        Log.debug("\u68c0\u67e5\u8fde\u63a5\u72b6\u6001 {} ", (Object)this.socket);
        try {
            byte[] header = new byte[10];
            Arrays.fill(header, (byte)0);
            byte[] hexLen = BytesUtil.long2buff(0L);
            System.arraycopy(hexLen, 0, header, 0, hexLen.length);
            header[8] = 111;
            header[9] = 0;
            this.socket.getOutputStream().write(header);
            if (this.socket.getInputStream().read(header) != header.length) {
                return false;
            }
            return header[9] == 0;
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u8fde\u63a5\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

