/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.upload.fastdfs.config;

import cn.novelweb.tool.upload.fastdfs.FastDfsClient;
import cn.novelweb.tool.upload.fastdfs.utils.IniFileReader;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsConfig {
    private static final Logger log = LoggerFactory.getLogger(FastDfsConfig.class);
    public static final FastDfsConfig DFS_CONFIG = new FastDfsConfig();
    private static final String FAST_DFS_SO_TIMEOUT = "fastdfs.soTimeout";
    private static final String FAST_DFS_CONNECT_TIMEOUT = "fastdfs.connectTimeout";
    private static final String FAST_DFS_MAX_TOTAL = "fastdfs.maxTotal";
    private static final String FAST_DFS_MAX_TOTAL_PER_KEY = "fastdfs.maxTotalPerKey";
    private static final String FAST_DFS_MAX_IDLE_PER_KEY = "fastdfs.maxIdlePerKey";
    private static final String FAST_DFS_TRACKERS = "fastdfs.tracker_servers";
    private static final String FAST_DFS_DEBUG_LOG = "fastdfs.debug_log";
    private static final int DEFAULT_SO_TIMEOUT = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_MAX_TOTAL = 200;
    private static final int DEFAULT_MAX_TOTAL_PER_KEY = 200;
    private static final int DEFAULT_MAX_IDLE_PER_KEY = 50;
    private int soTimeout = 10000;
    private int connectTimeout = 5000;
    private int maxTotal = 200;
    private int maxTotalPerKey = 200;
    private int maxIdlePerKey = 50;
    private Boolean debugLog;
    private String trackerServers;

    public static void init(String confFileName) {
        if (StringUtils.isBlank((String)confFileName)) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        IniFileReader iniReader = new IniFileReader(confFileName);
        try {
            FastDfsConfig.DFS_CONFIG.soTimeout = iniReader.getIntValue(FAST_DFS_SO_TIMEOUT, 10000);
            FastDfsConfig.DFS_CONFIG.connectTimeout = iniReader.getIntValue(FAST_DFS_CONNECT_TIMEOUT, 5000);
            FastDfsConfig.DFS_CONFIG.maxTotal = iniReader.getIntValue(FAST_DFS_MAX_TOTAL, 200);
            FastDfsConfig.DFS_CONFIG.maxTotalPerKey = iniReader.getIntValue(FAST_DFS_MAX_TOTAL_PER_KEY, 200);
            FastDfsConfig.DFS_CONFIG.maxIdlePerKey = iniReader.getIntValue(FAST_DFS_MAX_IDLE_PER_KEY, 50);
            FastDfsConfig.DFS_CONFIG.debugLog = iniReader.getBoolValue(FAST_DFS_DEBUG_LOG, true);
            FastDfsConfig.DFS_CONFIG.trackerServers = iniReader.getStrValue(FAST_DFS_TRACKERS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FastDfsClient.init(DFS_CONFIG);
    }

    public static FastDfsConfigBuilder builder() {
        return new FastDfsConfigBuilder();
    }

    public FastDfsConfig() {
    }

    public FastDfsConfig(int soTimeout, int connectTimeout, int maxTotal, int maxTotalPerKey, int maxIdlePerKey, Boolean debugLog, String trackerServers) {
        this.soTimeout = soTimeout;
        this.connectTimeout = connectTimeout;
        this.maxTotal = maxTotal;
        this.maxTotalPerKey = maxTotalPerKey;
        this.maxIdlePerKey = maxIdlePerKey;
        this.debugLog = debugLog;
        this.trackerServers = trackerServers;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getMaxTotalPerKey() {
        return this.maxTotalPerKey;
    }

    public int getMaxIdlePerKey() {
        return this.maxIdlePerKey;
    }

    public Boolean getDebugLog() {
        return this.debugLog;
    }

    public String getTrackerServers() {
        return this.trackerServers;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxTotalPerKey(int maxTotalPerKey) {
        this.maxTotalPerKey = maxTotalPerKey;
    }

    public void setMaxIdlePerKey(int maxIdlePerKey) {
        this.maxIdlePerKey = maxIdlePerKey;
    }

    public void setDebugLog(Boolean debugLog) {
        this.debugLog = debugLog;
    }

    public void setTrackerServers(String trackerServers) {
        this.trackerServers = trackerServers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FastDfsConfig)) {
            return false;
        }
        FastDfsConfig other = (FastDfsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSoTimeout() != other.getSoTimeout()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        if (this.getMaxTotalPerKey() != other.getMaxTotalPerKey()) {
            return false;
        }
        if (this.getMaxIdlePerKey() != other.getMaxIdlePerKey()) {
            return false;
        }
        Boolean this$debugLog = this.getDebugLog();
        Boolean other$debugLog = other.getDebugLog();
        if (this$debugLog == null ? other$debugLog != null : !((Object)this$debugLog).equals(other$debugLog)) {
            return false;
        }
        String this$trackerServers = this.getTrackerServers();
        String other$trackerServers = other.getTrackerServers();
        return !(this$trackerServers == null ? other$trackerServers != null : !this$trackerServers.equals(other$trackerServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FastDfsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSoTimeout();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getMaxTotal();
        result = result * 59 + this.getMaxTotalPerKey();
        result = result * 59 + this.getMaxIdlePerKey();
        Boolean $debugLog = this.getDebugLog();
        result = result * 59 + ($debugLog == null ? 43 : ((Object)$debugLog).hashCode());
        String $trackerServers = this.getTrackerServers();
        result = result * 59 + ($trackerServers == null ? 43 : $trackerServers.hashCode());
        return result;
    }

    public String toString() {
        return "FastDfsConfig(soTimeout=" + this.getSoTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", maxTotal=" + this.getMaxTotal() + ", maxTotalPerKey=" + this.getMaxTotalPerKey() + ", maxIdlePerKey=" + this.getMaxIdlePerKey() + ", debugLog=" + this.getDebugLog() + ", trackerServers=" + this.getTrackerServers() + ")";
    }

    public static class FastDfsConfigBuilder {
        private int soTimeout;
        private int connectTimeout;
        private int maxTotal;
        private int maxTotalPerKey;
        private int maxIdlePerKey;
        private Boolean debugLog;
        private String trackerServers;

        FastDfsConfigBuilder() {
        }

        public FastDfsConfigBuilder soTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public FastDfsConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public FastDfsConfigBuilder maxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public FastDfsConfigBuilder maxTotalPerKey(int maxTotalPerKey) {
            this.maxTotalPerKey = maxTotalPerKey;
            return this;
        }

        public FastDfsConfigBuilder maxIdlePerKey(int maxIdlePerKey) {
            this.maxIdlePerKey = maxIdlePerKey;
            return this;
        }

        public FastDfsConfigBuilder debugLog(Boolean debugLog) {
            this.debugLog = debugLog;
            return this;
        }

        public FastDfsConfigBuilder trackerServers(String trackerServers) {
            this.trackerServers = trackerServers;
            return this;
        }

        public FastDfsConfig build() {
            return new FastDfsConfig(this.soTimeout, this.connectTimeout, this.maxTotal, this.maxTotalPerKey, this.maxIdlePerKey, this.debugLog, this.trackerServers);
        }

        public String toString() {
            return "FastDfsConfig.FastDfsConfigBuilder(soTimeout=" + this.soTimeout + ", connectTimeout=" + this.connectTimeout + ", maxTotal=" + this.maxTotal + ", maxTotalPerKey=" + this.maxTotalPerKey + ", maxIdlePerKey=" + this.maxIdlePerKey + ", debugLog=" + this.debugLog + ", trackerServers=" + this.trackerServers + ")";
        }
    }
}

