/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.img;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil
extends ImgUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    private static final String[] IMAGES_TYPE = new String[]{"jpg", "png"};

    public static boolean backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        return ImageUtil.backgroundRemoval(new File(inputPath), new File(outputPath), tolerance);
    }

    public static boolean backgroundRemoval(File input, File output, int tolerance) {
        if (!input.exists()) {
            log.error("\u6ca1\u6709\u8981\u8fdb\u884c\u64cd\u4f5c\u7684\u56fe\u7247");
            return false;
        }
        String type = FileTypeUtil.getType((File)input);
        if (!ArrayUtil.contains((Object[])IMAGES_TYPE, (Object)type)) {
            log.error("\u6587\u4ef6\u7c7b\u578b\u4e0d\u88ab\u652f\u6301");
            return false;
        }
        tolerance = Math.min(255, Math.max(tolerance, 0));
        try {
            BufferedImage bufferedImage = ImageIO.read(input);
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
            Graphics graphics = image.getGraphics();
            graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
            Object[] removeRgb = ImageUtil.getRemoveRgb(bufferedImage);
            String mainColor = ImageUtil.getMainColor(bufferedImage);
            int alpha = 0;
            for (int y = image.getMinY(); y < image.getHeight(); ++y) {
                for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                    boolean isTrue;
                    int rgb = image.getRGB(x, y);
                    String hex = ImageUtil.rgbToHex((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                    boolean bl = isTrue = ArrayUtil.contains((Object[])removeRgb, (Object)hex) || ImageUtil.areColorsWithinTolerance(ImageUtil.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                    if (isTrue) {
                        rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                    }
                    image.setRGB(x, y, rgb);
                }
            }
            graphics.drawImage(image, 0, 0, imageIcon.getImageObserver());
            return ImageIO.write((RenderedImage)image, FileUtil.extName((String)input.getAbsolutePath()), output);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String[] getRemoveRgb(BufferedImage image) {
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ImageUtil.rgbToHex((leftUpPixel & 0xFF0000) >> 16, (leftUpPixel & 0xFF00) >> 8, leftUpPixel & 0xFF);
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ImageUtil.rgbToHex((upMiddlePixel & 0xFF0000) >> 16, (upMiddlePixel & 0xFF00) >> 8, upMiddlePixel & 0xFF);
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ImageUtil.rgbToHex((rightUpPixel & 0xFF0000) >> 16, (rightUpPixel & 0xFF00) >> 8, rightUpPixel & 0xFF);
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ImageUtil.rgbToHex((rightMiddlePixel & 0xFF0000) >> 16, (rightMiddlePixel & 0xFF00) >> 8, rightMiddlePixel & 0xFF);
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ImageUtil.rgbToHex((lowerRightPixel & 0xFF0000) >> 16, (lowerRightPixel & 0xFF00) >> 8, lowerRightPixel & 0xFF);
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ImageUtil.rgbToHex((lowerMiddlePixel & 0xFF0000) >> 16, (lowerMiddlePixel & 0xFF00) >> 8, lowerMiddlePixel & 0xFF);
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ImageUtil.rgbToHex((leftLowerPixel & 0xFF0000) >> 16, (leftLowerPixel & 0xFF00) >> 8, leftLowerPixel & 0xFF);
        int leftMiddlePixel = image.getRGB(1, height / 2);
        String leftMiddle = ImageUtil.rgbToHex((leftMiddlePixel & 0xFF0000) >> 16, (leftMiddlePixel & 0xFF00) >> 8, leftMiddlePixel & 0xFF);
        return new String[]{leftUp, upMiddle, rightUp, rightMiddle, lowerRight, lowerMiddle, leftLower, leftMiddle};
    }

    public static String rgbToHex(int r, int g, int b) {
        boolean isRgb;
        boolean bl = isRgb = 0 <= r && r <= 255 && 0 <= g && g <= 255 && 0 <= b && b <= 255;
        if (isRgb) {
            return String.format("#%02X%02X%02X", r, g, b);
        }
        log.error("RGB\u989c\u8272\u503c\u53ea\u80fd\u4e3a0~255\u4e4b\u95f4\u7684\u6574\u6570");
        return "";
    }

    public static Color hexToRgb(String hex) {
        return new Color(Integer.parseInt(hex.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, int tolerance) {
        return ImageUtil.areColorsWithinTolerance(color1, color2, new Color(tolerance, tolerance, tolerance));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, Color tolerance) {
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color1.getGreen() - color2.getGreen() > -tolerance.getGreen();
    }

    public static String getMainColor(String input) {
        return ImageUtil.getMainColor(new File(input));
    }

    public static String getMainColor(File input) {
        try {
            return ImageUtil.getMainColor(ImageIO.read(input));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getMainColor(BufferedImage bufferedImage) {
        int rgbLength;
        if (bufferedImage == null) {
            log.error("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
            return "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int y = bufferedImage.getMinY(); y < bufferedImage.getHeight(); ++y) {
            for (int x = bufferedImage.getMinX(); x < bufferedImage.getWidth(); ++x) {
                int pixel = bufferedImage.getRGB(x, y);
                list.add(((pixel & 0xFF0000) >> 16) + "-" + ((pixel & 0xFF00) >> 8) + "-" + (pixel & 0xFF));
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size());
        for (String string : list) {
            Integer integer = (Integer)map.get(string);
            if (integer == null) {
                integer = 1;
            } else {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer + 1);
            }
            map.put(string, integer);
        }
        String max = "";
        long num = 0L;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Integer temp = (Integer)entry.getValue();
            if (!StringUtils.isBlank((String)max) && (long)temp.intValue() <= num) continue;
            max = key;
            num = temp.intValue();
        }
        String[] strings = max.split("-");
        if (strings.length == (rgbLength = 3)) {
            return ImageUtil.rgbToHex(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
        }
        return "";
    }
}

