/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.date;

import cn.hutool.core.date.BetweenFormater;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DateUtils {
    public static String[] sortByDate(String startTime, String endTime, String format) {
        long endTimeMillisecond;
        boolean isStartTime;
        if (StringUtils.isBlank((String)endTime)) {
            endTime = DateUtil.today();
        }
        if (StringUtils.isBlank((String)startTime)) {
            startTime = DateUtil.today();
        }
        if (!(isStartTime = DateUtils.isTime(endTime, format))) {
            return null;
        }
        boolean isEndTime = DateUtils.isTime(endTime, format);
        if (!isEndTime) {
            return null;
        }
        long startTimeMillisecond = DateUtil.parse((CharSequence)startTime, (String)format).getTime();
        if (startTimeMillisecond < (endTimeMillisecond = DateUtil.parse((CharSequence)endTime, (String)format).getTime())) {
            return new String[]{endTime, startTime};
        }
        return new String[]{startTime, endTime};
    }

    public static Date[] sortByDate(Date startTime, Date endTime) {
        if (endTime == null) {
            endTime = DateUtil.date();
        }
        if (startTime == null) {
            startTime = DateUtil.date();
        }
        if (startTime.getTime() < endTime.getTime()) {
            return new Date[]{endTime, startTime};
        }
        return new Date[]{startTime, endTime};
    }

    public static boolean isTime(String time, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        try {
            format.setLenient(false);
            format.parse(time);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String timeDifference(Date time) {
        if (time == null) {
            return "";
        }
        long timeDifference = DateUtil.between((Date)DateUtil.date(), (Date)time, (DateUnit)DateUnit.MS);
        if (timeDifference < DateUnit.MINUTE.getMillis()) {
            int just = 5;
            if (timeDifference < DateUnit.SECOND.getMillis() * (long)just) {
                return "\u521a\u521a";
            }
            return DateUtil.formatBetween((long)timeDifference, (BetweenFormater.Level)BetweenFormater.Level.SECOND) + "\u524d";
        }
        if (timeDifference > DateUnit.MINUTE.getMillis() && timeDifference < DateUnit.HOUR.getMillis()) {
            return DateUtil.formatBetween((long)timeDifference, (BetweenFormater.Level)BetweenFormater.Level.MINUTE) + "\u949f\u524d";
        }
        if (timeDifference >= DateUnit.HOUR.getMillis() && timeDifference < DateUnit.DAY.getMillis()) {
            return DateUtil.formatBetween((long)timeDifference, (BetweenFormater.Level)BetweenFormater.Level.HOUR) + "\u524d";
        }
        long twentyDays = DateUnit.DAY.getMillis() * 20L;
        if (timeDifference >= DateUnit.DAY.getMillis() && timeDifference < twentyDays) {
            return DateUtil.formatBetween((long)timeDifference, (BetweenFormater.Level)BetweenFormater.Level.DAY) + "\u524d";
        }
        return DateUtil.format((Date)time, (String)"yyyy-MM-dd");
    }

    public static String getPastDate(int past) {
        DateTime dateTime = DateUtil.offsetDay((Date)DateUtil.date(), (int)(past * -1));
        return DateUtil.formatDate((Date)dateTime);
    }

    public static List<String> getPastDateList(int intervals) {
        ArrayList<String> pastDaysList = new ArrayList<String>();
        for (int i = intervals; i > 0; --i) {
            pastDaysList.add(DateUtils.getPastDate(i));
        }
        return pastDaysList;
    }

    public static long getTimeConversion(String time) {
        boolean isTime = DateUtils.isTime(time, "HH:mm:ss.SSS");
        if (!isTime) {
            return -1L;
        }
        String string = new SimpleDateFormat("yyyy-MM-dd").format((Date)DateUtil.date());
        DateTime beginDate = DateUtil.parse((CharSequence)(string + " 00:00:00.000"), (String)"yyyy-MM-dd HH:mm:ss.SSS");
        DateTime endDate = DateUtil.parse((CharSequence)(string + " " + time), (String)"yyyy-MM-dd HH:mm:ss.SSS");
        return DateUtil.between((Date)beginDate, (Date)endDate, (DateUnit)DateUnit.MS);
    }

    public static String getBaiDuTime() {
        return DateUtils.getBaiDuTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String getBaiDuTime(String format) {
        try {
            URL url = new URL("http://www.baidu.com");
            URLConnection urlConnection = url.openConnection();
            urlConnection.connect();
            long connectionDate = urlConnection.getDate();
            Date date = new Date(connectionDate);
            return DateUtils.format(date, format);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String format(long date) {
        return DateUtil.format((Date)DateUtil.date((long)date), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String format(long date, String format) {
        return DateUtil.format((Date)DateUtil.date((long)date), (String)format);
    }

    public static String format(Date date) {
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String format) {
        return DateUtil.format((Date)date, (String)format);
    }

    public static Date parse(long date) {
        return DateUtil.date((long)date);
    }

    public static Date parse(String date) {
        return DateUtil.parse((CharSequence)date);
    }

    public static Date parse(String date, String format) {
        return DateUtil.parse((CharSequence)date, (String)format);
    }

    public static Boolean timeOverlap(Date start, Date end, Date startInterval, Date endInterval) {
        Date[] interval1 = DateUtils.sortByDate(start, end);
        Date[] interval2 = DateUtils.sortByDate(startInterval, endInterval);
        return interval2[1].before(interval1[0]) && interval2[0].after(interval1[1]);
    }
}

