/*
 * Decompiled with CFR 0.152.
 */
package cn.novelweb.tool.cron;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.cron.Scheduler;
import cn.hutool.cron.pattern.CronPattern;
import cn.hutool.setting.Setting;
import cn.hutool.setting.SettingRuntimeException;
import cn.novelweb.tool.cron.pojo.TaskParam;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimingTask {
    private static final Logger log = LoggerFactory.getLogger(TimingTask.class);
    private static final Scheduler SCHEDULER = new Scheduler();
    private static final Lock LOCK = new ReentrantLock();
    public static final String CRON_TAB_CONFIG_PATH = "config/cron.setting";
    public static final String CRON_TAB_CONFIG_PATH2 = "cron.setting";
    private static Setting cronTabSetting;

    private TimingTask() {
    }

    public static void setCronSetting(Setting cronSetting) {
        cronTabSetting = cronSetting;
    }

    public static void setMatchSecond(boolean isMatchSecond) {
        SCHEDULER.setMatchSecond(isMatchSecond);
    }

    public static String schedule(String id, TaskParam taskParam) {
        SCHEDULER.schedule(id, taskParam.getCron(), () -> TimingTask.performTasks(taskParam));
        return id;
    }

    public static String schedule(TaskParam taskParam) {
        return SCHEDULER.schedule(taskParam.getCron(), () -> TimingTask.performTasks(taskParam));
    }

    private static void performTasks(TaskParam taskParam) {
        Class clazz = ClassLoaderUtil.loadClass((String)taskParam.getClassPath());
        Object object = ReflectUtil.newInstanceIfPossible((Class)clazz);
        if (object == null) {
            log.error("\u83b7\u53d6\u5230\u7684\u7c7b\u4e3aNULL");
            return;
        }
        if (taskParam.getParam() == null) {
            ReflectUtil.invoke((Object)object, (String)taskParam.getMethodName(), (Object[])new Object[0]);
            return;
        }
        ReflectUtil.invoke((Object)object, (String)taskParam.getMethodName(), (Object[])taskParam.getParam());
    }

    public static String schedule(String schedulingPattern, Runnable task) {
        return SCHEDULER.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        SCHEDULER.schedule(cronSetting);
    }

    public static void remove(String schedulerId) {
        SCHEDULER.deschedule(schedulerId);
    }

    public static void updatePattern(String id, String cronExpression) {
        SCHEDULER.updatePattern(id, new CronPattern(cronExpression));
    }

    public static Scheduler getScheduler() {
        return SCHEDULER;
    }

    public static void start() {
        TimingTask.start(false);
    }

    public static synchronized void start(boolean isDaemon) {
        if (SCHEDULER.isStarted()) {
            throw new UtilException("\u8ba1\u5212\u7a0b\u5e8f\u5df2\u542f\u52a8\uff0c\u8bf7\u5148\u505c\u6b62\u5b83!");
        }
        LOCK.lock();
        try {
            if (null == cronTabSetting) {
                TimingTask.setCronSetting(CRON_TAB_CONFIG_PATH);
            }
            if (null == cronTabSetting) {
                TimingTask.setCronSetting(CRON_TAB_CONFIG_PATH2);
            }
        }
        finally {
            LOCK.unlock();
        }
        TimingTask.schedule(cronTabSetting);
        SCHEDULER.start(isDaemon);
    }

    public static void setCronSetting(String cronSettingPath) {
        try {
            cronTabSetting = new Setting(cronSettingPath, Setting.DEFAULT_CHARSET, false);
        }
        catch (NoResourceException | SettingRuntimeException throwable) {
            // empty catch block
        }
    }

    public static void restart() {
        LOCK.lock();
        try {
            if (null != cronTabSetting) {
                cronTabSetting.load();
            }
            if (SCHEDULER.isStarted()) {
                SCHEDULER.stop(true);
            }
        }
        finally {
            LOCK.unlock();
        }
        TimingTask.schedule(cronTabSetting);
        SCHEDULER.start();
    }

    public static void stop() {
        SCHEDULER.stop();
    }
}

