/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.report.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.schedule.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CheckMessagePayload
implements IModel {
    public static final String MSG_ID = "msg_id";
    public static final String REGISTRATION_IDS = "registration_ids";
    public static final String DATE = "date";
    private long msgId = -1L;
    private List<String> registrationIds;
    private String date;
    private Gson gson = new Gson();

    public CheckMessagePayload(long msgId, List<String> rids, String date) {
        this.msgId = msgId;
        this.registrationIds = rids;
        this.date = date;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject jsonObject = new JsonObject();
        if (this.msgId != -1L) {
            jsonObject.addProperty(MSG_ID, (Number)this.msgId);
        }
        if (null != this.registrationIds) {
            JsonArray jsonArray = new JsonArray();
            for (String rid : this.registrationIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(rid));
            }
            jsonObject.add(REGISTRATION_IDS, (JsonElement)jsonArray);
        }
        if (null != this.date) {
            jsonObject.addProperty(DATE, this.date);
        }
        return jsonObject;
    }

    public String toString() {
        return this.gson.toJson(this.toJSON());
    }

    private static boolean isDayFormat(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            simpleDateFormat.parse(date);
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class Builder {
        private long msgId;
        private List<String> registrationIds = new ArrayList<String>();
        private String date;

        public Builder setMsgId(long msgId) {
            this.msgId = msgId;
            return this;
        }

        public Builder setRegistrationIds(String[] rids) {
            Preconditions.checkArgument((rids != null && rids.length > 0 ? 1 : 0) != 0, (Object)"Registration ids is empty");
            Collections.addAll(this.registrationIds, rids);
            return this;
        }

        public Builder setRegistrationsIds(List<String> rids) {
            Preconditions.checkArgument((rids != null && rids.size() > 0 ? 1 : 0) != 0, (Object)"Registration ids is empty");
            this.registrationIds = rids;
            return this;
        }

        public Builder addRegistrationIds(String ... rids) {
            if (null == rids) {
                return this;
            }
            Collections.addAll(this.registrationIds, rids);
            return this;
        }

        public Builder addRegistrationIds(List<String> rids) {
            this.registrationIds.addAll(rids);
            return this;
        }

        public Builder setDate(String date) {
            Preconditions.checkArgument((boolean)CheckMessagePayload.isDayFormat(date), (Object)"Date format is invalid");
            this.date = date;
            return this;
        }

        public CheckMessagePayload build() {
            return new CheckMessagePayload(this.msgId, this.registrationIds, this.date);
        }
    }
}

