/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.picture;

import cn.javaex.htool.core.codec.Base64Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static final int MIN_PIC_WIDTH = 10;
    private static final int MIN_PIC_HEIGHT = 10;
    private static final int PIC_ANGEL = 315;
    private static final int X_PADDING = 150;
    private static final int Y_PADDING = 200;
    private static final int NUM_TWO = 2;

    public static BufferedImage addWatermark(BufferedImage srcBuffer, String text, Font font, Color color) {
        try {
            int srcImgWidth = srcBuffer.getWidth();
            int srcImgHeight = srcBuffer.getHeight();
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcBuffer, 0, 0, srcImgWidth, srcImgHeight, null);
            if (color == null) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(color);
            }
            g.setFont(font);
            int stringWidth = g.getFontMetrics(g.getFont()).charsWidth(text.toCharArray(), 0, text.length());
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            int x = srcImgWidth - stringWidth - 20;
            int y = srcImgHeight - 20;
            g.drawString(text, x, y);
            g.dispose();
            return bufImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return srcBuffer;
        }
    }

    public static BufferedImage addWatermarks(BufferedImage srcBuffer, String text, Font font, Color color) {
        try {
            int srcImgWidth = srcBuffer.getWidth();
            int srcImgHeight = srcBuffer.getHeight();
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcBuffer, 0, 0, srcImgWidth, srcImgHeight, null);
            if (color == null) {
                g.setColor(Color.WHITE);
            } else {
                g.setColor(color);
            }
            g.setFont(font);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(text, font, frc);
            int stringWidth = g.getFontMetrics(g.getFont()).charsWidth(text.toCharArray(), 0, text.length());
            g.rotate(Math.toRadians(315.0), (double)srcImgWidth / 2.0, (double)srcImgHeight / 2.0);
            g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            for (int x = -srcImgHeight / 2; x < srcImgWidth + srcImgHeight / 2; x += stringWidth + 150) {
                for (int y = -srcImgWidth / 2; y < srcImgHeight + srcImgWidth / 2; y += 200) {
                    Shape sha = tl.getOutline(AffineTransform.getTranslateInstance(x, y));
                    g.fill(sha);
                }
            }
            g.dispose();
            return bufImg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return srcBuffer;
        }
    }

    public static void base64ToFile(String base64Image, String imageFilePath) throws IOException {
        String image = base64Image.substring(22);
        if (image.startsWith(",")) {
            image = base64Image.substring(23);
        }
        byte[] bytes = Base64Utils.decodeByte((String)image);
        try (FileOutputStream outStream = new FileOutputStream(imageFilePath);){
            ((OutputStream)outStream).write(bytes);
            outStream.flush();
        }
    }

    public static String toBase64Str(String imageFilePath) {
        byte[] bytes = null;
        try (FileInputStream inputStream = new FileInputStream(imageFilePath);){
            bytes = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "data:image/jpeg;base64," + Base64Utils.encodeByte(bytes);
    }

    public static BufferedImage read(String imageFilePath) throws IOException {
        return ImageIO.read(new File(imageFilePath));
    }

    public static void write(BufferedImage bufferedImage, String imageFilePath, String imageType) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, imageType, new File(imageFilePath));
    }

    public static List<String> listImages(String htmlStr) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("<(img|IMG)(.*?)(>|></img>|/>)");
        Matcher matcher = p.matcher(htmlStr);
        boolean hasPic = matcher.find();
        if (hasPic) {
            while (hasPic) {
                String group = matcher.group(2);
                Pattern srcText = Pattern.compile("(src|SRC)=(\"|')(.*?)(\"|')");
                Matcher matcher2 = srcText.matcher(group);
                if (matcher2.find()) {
                    try {
                        list.add(matcher2.group(3));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                hasPic = matcher.find();
            }
        }
        return list;
    }

    public static final BufferedImage compress(BufferedImage srcBuffer, int width, int height) {
        if (width < 10) {
            width = 10;
        }
        if (height < 10) {
            height = 10;
        }
        double ratio = 0.0;
        Image itemp = srcBuffer.getScaledInstance(width, height, 1);
        if (srcBuffer.getHeight() > height || srcBuffer.getWidth() > width) {
            double ratioWhidth;
            double ratioHeight = new Integer(height).doubleValue() / (double)srcBuffer.getHeight();
            ratio = ratioHeight > (ratioWhidth = new Integer(width).doubleValue() / (double)srcBuffer.getWidth()) ? ratioHeight : ratioWhidth;
            AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(ratio, ratio), null);
            itemp = op.filter(srcBuffer, null);
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        if (width == itemp.getWidth(null)) {
            g.drawImage(itemp, 0, (height - itemp.getHeight(null)) / 2, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
        } else {
            g.drawImage(itemp, (width - itemp.getWidth(null)) / 2, 0, itemp.getWidth(null), itemp.getHeight(null), Color.white, null);
        }
        g.dispose();
        itemp = image;
        return (BufferedImage)itemp;
    }

    public static final BufferedImage compress(BufferedImage srcBuffer, float quality) {
        if (quality <= 0.0f || quality > 1.0f) {
            System.err.println("\u53c2\u6570\u4e0d\u5408\u6cd5");
            return null;
        }
        int width = (int)((float)srcBuffer.getWidth() * quality);
        int height = (int)((float)srcBuffer.getHeight() * quality);
        return ImageUtils.compress(srcBuffer, width, height);
    }

    public static BufferedImage cut(BufferedImage bufferedImage, int startX, int startY, int endX, int endY) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (startX == -1) {
            startX = 0;
        }
        if (startY == -1) {
            startY = 0;
        }
        if (endX == -1) {
            endX = width - 1;
        }
        if (endY == -1) {
            endY = height - 1;
        }
        BufferedImage result = new BufferedImage(endX - startX, endY - startY, 4);
        for (int x = startX; x < endX; ++x) {
            for (int y = startY; y < endY; ++y) {
                int rgb = bufferedImage.getRGB(x, y);
                result.setRGB(x - startX, y - startY, rgb);
            }
        }
        return result;
    }
}

