/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.crypto.sign;

import cn.javaex.htool.core.codec.Base64Utils;
import cn.javaex.htool.core.string.StringUtils;
import cn.javaex.htool.crypto.sign.Sign;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class SignUtils
extends Sign {
    public static String sign(String content, String privateKey) throws Exception {
        byte[] data = content.getBytes("UTF-8");
        byte[] keyBytes = Base64Utils.decodeByte((String)privateKey);
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(key);
        signature.update(data);
        return StringUtils.formatNoSTRN((String)Base64Utils.encodeByte((byte[])signature.sign()));
    }

    public static boolean verify(String content, String publicKey, String sign) {
        try {
            byte[] data = content.getBytes("UTF-8");
            byte[] keyBytes = Base64Utils.decodeByte((String)publicKey);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey key = keyFactory.generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(key);
            signature.update(data);
            return signature.verify(Base64Utils.decodeByte((String)sign));
        }
        catch (Exception exception) {
            return false;
        }
    }
}

