/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.crypto.rsa;

import cn.javaex.htool.core.codec.Base64Utils;
import cn.javaex.htool.core.string.StringUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSA {
    public static final String KEY_ALGORTHM = "RSA";
    private String publicKey;
    private String privateKey;

    public RSA() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORTHM);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            this.publicKey = StringUtils.formatNoSTRN((String)Base64Utils.encodeByte((byte[])publicKey.getEncoded()));
            this.privateKey = StringUtils.formatNoSTRN((String)Base64Utils.encodeByte((byte[])privateKey.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }
}

