/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date.handler;

import cn.javaex.htool.core.date.DateUtils;
import cn.javaex.htool.core.date.handler.DateHandler;
import cn.javaex.htool.core.date.handler.LocalDateHandler;
import cn.javaex.htool.core.date.handler.LocalDateTimeHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.function.Function;

public class TimeHandler {
    protected static final ZoneId ZONE = ZoneId.systemDefault();

    public <T> String format(T date, String pattern) throws ParseException {
        if (date instanceof Date) {
            Function<Date, String> func = DateHandler.FORMAT_MAP.get(pattern);
            if (func != null) {
                return func.apply((Date)date);
            }
            return new SimpleDateFormat(pattern).format(date);
        }
        if (date instanceof LocalDateTime) {
            Function<LocalDateTime, String> func = LocalDateTimeHandler.FORMAT_MAP.get(pattern);
            if (func != null) {
                return func.apply((LocalDateTime)date);
            }
            return ((DateFormat)date).format(DateTimeFormatter.ofPattern(pattern));
        }
        if (date instanceof LocalDate) {
            Function<LocalDate, String> func = LocalDateHandler.FORMAT_MAP.get(pattern);
            if (func != null) {
                return func.apply((LocalDate)date);
            }
            return ((DateFormat)date).format(DateTimeFormatter.ofPattern(pattern));
        }
        return null;
    }

    public <T> long yearDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd");
        String timestr2 = this.format(time2, "yyyy-MM-dd");
        LocalDate localDate1 = DateUtils.parseLocalDate(timestr1, "yyyy-MM-dd");
        LocalDate localDate2 = DateUtils.parseLocalDate(timestr2, "yyyy-MM-dd");
        return Period.between(localDate1, localDate2).getYears();
    }

    public <T> long monthDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd");
        String timestr2 = this.format(time2, "yyyy-MM-dd");
        LocalDate localDate1 = DateUtils.parseLocalDate(timestr1, "yyyy-MM-dd");
        LocalDate localDate2 = DateUtils.parseLocalDate(timestr2, "yyyy-MM-dd");
        return Period.between(localDate1, localDate2).getYears() * 12 + Period.between(localDate1, localDate2).getMonths();
    }

    public <T> long dayDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd HH:mm:ss");
        String timestr2 = this.format(time2, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime1 = DateUtils.parseLocalDateTime(timestr1, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime2 = DateUtils.parseLocalDateTime(timestr2, "yyyy-MM-dd HH:mm:ss");
        return Duration.between(localDateTime1, localDateTime2).toDays();
    }

    public <T> long hourDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd HH:mm:ss");
        String timestr2 = this.format(time2, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime1 = DateUtils.parseLocalDateTime(timestr1, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime2 = DateUtils.parseLocalDateTime(timestr2, "yyyy-MM-dd HH:mm:ss");
        return Duration.between(localDateTime1, localDateTime2).toHours();
    }

    public <T> long minuteDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd HH:mm:ss");
        String timestr2 = this.format(time2, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime1 = DateUtils.parseLocalDateTime(timestr1, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime2 = DateUtils.parseLocalDateTime(timestr2, "yyyy-MM-dd HH:mm:ss");
        return Duration.between(localDateTime1, localDateTime2).toMinutes();
    }

    public <T> long secondDifference(T time1, T time2) throws ParseException {
        String timestr1 = this.format(time1, "yyyy-MM-dd HH:mm:ss");
        String timestr2 = this.format(time2, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime1 = DateUtils.parseLocalDateTime(timestr1, "yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime2 = DateUtils.parseLocalDateTime(timestr2, "yyyy-MM-dd HH:mm:ss");
        return Duration.between(localDateTime1, localDateTime2).getSeconds();
    }
}

