/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date.handler;

import cn.javaex.htool.core.date.constant.DatePattern;
import cn.javaex.htool.core.date.handler.TimeHandler;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LocalDateTimeHandler
extends TimeHandler {
    public static final Map<String, Function<String, LocalDateTime>> PARSE_MAP;
    public static final Map<String, Function<LocalDateTime, String>> FORMAT_MAP;

    public LocalDateTime parse(String text, String pattern) {
        Function<String, LocalDateTime> func = PARSE_MAP.get(pattern);
        if (func != null) {
            return func.apply(text);
        }
        return LocalDateTime.parse(text, DateTimeFormatter.ofPattern(pattern));
    }

    public Date parseDate(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZONE).toInstant();
        return Date.from(instant);
    }

    public LocalDate parseLocalDate(LocalDateTime localDateTime) {
        return localDateTime.toLocalDate();
    }

    static {
        Field[] fields;
        PARSE_MAP = new ConcurrentHashMap<String, Function<String, LocalDateTime>>();
        FORMAT_MAP = new ConcurrentHashMap<String, Function<LocalDateTime, String>>();
        for (Field field : fields = DatePattern.class.getDeclaredFields()) {
            try {
                String pattern = (String)field.get(DatePattern.class);
                PARSE_MAP.put(pattern, text -> LocalDateTime.parse(text, DateTimeFormatter.ofPattern(pattern)));
                FORMAT_MAP.put(pattern, localDateTime -> localDateTime.format(DateTimeFormatter.ofPattern(pattern)));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

