/*
 * Decompiled with CFR 0.152.
 */
package cn.javaex.htool.core.date.handler;

import cn.javaex.htool.core.date.constant.DatePattern;
import cn.javaex.htool.core.date.handler.TimeHandler;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LocalDateHandler
extends TimeHandler {
    public static final Map<String, Function<String, LocalDate>> PARSE_MAP;
    public static final Map<String, Function<LocalDate, String>> FORMAT_MAP;

    public LocalDate parse(String text, String pattern) {
        Function<String, LocalDate> func = PARSE_MAP.get(pattern);
        if (func != null) {
            return func.apply(text);
        }
        return LocalDate.parse(text, DateTimeFormatter.ofPattern(pattern));
    }

    public Date parseDate(LocalDate localDate) {
        Instant instant = localDate.atStartOfDay().atZone(ZONE).toInstant();
        return Date.from(instant);
    }

    public LocalDateTime parseLocalDateTime(LocalDate localDate) {
        return localDate.atTime(LocalTime.MIN);
    }

    static {
        Field[] fields;
        PARSE_MAP = new ConcurrentHashMap<String, Function<String, LocalDate>>();
        FORMAT_MAP = new ConcurrentHashMap<String, Function<LocalDate, String>>();
        for (Field field : fields = DatePattern.class.getDeclaredFields()) {
            try {
                String pattern = (String)field.get(DatePattern.class);
                PARSE_MAP.put(pattern, text -> LocalDate.parse(text, DateTimeFormatter.ofPattern(pattern)));
                FORMAT_MAP.put(pattern, localDate -> localDate.format(DateTimeFormatter.ofPattern(pattern)));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

