/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.convert.Converter;
import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.convert.impl.ArrayConverter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert((Object)jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, (Object)jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        JSONDeserializer<?> deserializer;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON && null != (deserializer = GlobalSerializeMapping.getDeserializer(targetType))) {
            return (T)deserializer.deserialize((JSON)value);
        }
        Object targetValue = Convert.convertWithCheck((Type)targetType, (Object)value, null, (boolean)ignoreError);
        if (null == targetValue && !ignoreError) {
            if (StrUtil.isBlankIfStr((Object)value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", new Object[]{value, ObjectUtil.defaultIfNull((Object)TypeUtil.getClass((Type)targetType), (Object)targetType)});
        }
        return (T)targetValue;
    }

    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom(JSON.class, JSONConverter.class);
        registry.putCustom(JSONObject.class, JSONConverter.class);
        registry.putCustom(JSONArray.class, JSONConverter.class);
    }
}

