/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanResolver;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSONGetter<String>
implements JSON,
Map<String, Object> {
    private static final int DEFAULT_CAPACITY = 16;
    private final Map<String, Object> rawHashMap;
    private boolean ignoreNullValue = true;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(boolean isOrder) {
        this(16, isOrder);
    }

    public JSONObject(int capacity, boolean isOrder) {
        this(capacity, false, isOrder);
    }

    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this.rawHashMap = isIgnoreCase ? (isOrder ? new CaseInsensitiveLinkedMap(capacity) : new CaseInsensitiveMap(capacity)) : (isOrder ? new LinkedHashMap(capacity) : new HashMap(capacity));
    }

    public JSONObject(JSONObject jsonObject, String ... names) {
        this();
        for (String name : names) {
            try {
                this.putOnce(name, jsonObject.getObj(name));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        this.init(x);
    }

    public JSONObject(Object source) {
        this(source, true);
    }

    public JSONObject(Object source, boolean ignoreNullValue) {
        this();
        this.ignoreNullValue = ignoreNullValue;
        if (null != source) {
            if (source instanceof Map) {
                for (Map.Entry e : ((Map)source).entrySet()) {
                    Object value = e.getValue();
                    if (ignoreNullValue && value == null) continue;
                    this.rawHashMap.put(Convert.toStr(e.getKey()), JSONUtil.wrap(value, ignoreNullValue));
                }
            } else if (source instanceof String) {
                this.init((String)source);
            } else if (!(source instanceof Number)) {
                this.populateMap(source);
            }
        }
    }

    public JSONObject(Object pojo, String[] names) {
        this();
        Class<?> c = pojo.getClass();
        for (String name : names) {
            try {
                Field field = c.getField(name);
                if (null == field) continue;
                this.putOpt(name, field.get(pojo));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public boolean isNull(String key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.put(value);
        }
        return ja;
    }

    public <T> T toBean(Class<T> clazz) {
        return (T)this.toBean((T)clazz, false);
    }

    public <T> T toBean(Class<T> clazz, boolean ignoreError) {
        return (T)this.toBean(ReflectUtil.newInstance(clazz, (Object[])new Object[0]), ignoreError);
    }

    public <T> T toBean(Type type) {
        return (T)this.toBean((T)type, false);
    }

    public <T> T toBean(Type type, boolean ignoreError) {
        Class clazz = TypeUtil.getClass((Type)type);
        if (null == clazz) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Can not know Class of Type {} !", (Object[])new Object[]{type}));
        }
        return (T)this.toBean(ReflectUtil.newInstance((Class)clazz, (Object[])new Object[0]), ignoreError);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBean(T bean, boolean ignoreError) {
        return InternalJSONUtil.toBean(this, bean, ignoreError);
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    @Override
    public Object getByExp(String expression) {
        return BeanResolver.resolveBean((Object)this, (String)expression);
    }

    @Override
    public <T> T getByExp(String expression, Class<T> resultType) {
        return (T)InternalJSONUtil.jsonConvert(resultType, this.getByExp(expression), true);
    }

    @Override
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            InternalJSONUtil.testValidity(value);
            this.rawHashMap.put(key, JSONUtil.wrap(value, this.ignoreNullValue));
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JSONException(StrUtil.format((CharSequence)"Duplicate key \"{}\"", (Object[])new Object[]{key}));
            }
            this.put(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).put(value);
        } else {
            this.put(key, (Object)new JSONArray().put(object).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.put(key, (Object)new JSONArray().put(value));
        } else if (object instanceof JSONArray) {
            this.put(key, (Object)((JSONArray)object).put(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.put(key, (Object)1);
        } else if (value instanceof BigInteger) {
            this.put(key, (Object)((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.put(key, (Object)((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.put(key, (Object)((Integer)value + 1));
        } else if (value instanceof Long) {
            this.put(key, (Object)((Long)value + 1L));
        } else if (value instanceof Double) {
            this.put(key, (Object)((Double)value + 1.0));
        } else if (value instanceof Float) {
            this.put(key, (Object)Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawHashMap == null ? 0 : this.rawHashMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return !(this.rawHashMap == null ? other.rawHashMap != null : !this.rawHashMap.equals(other.rawHashMap));
    }

    public String toString() {
        try {
            return this.toJSONString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toStringPretty() throws JSONException {
        return this.toJSONString(4);
    }

    @Override
    public String toJSONString(int indentFactor) throws JSONException {
        StringWriter w = new StringWriter();
        return this.write(w, indentFactor, 0).toString();
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        boolean commanate = false;
        int length = this.size();
        Iterator<String> keys = this.keySet().iterator();
        try {
            writer.write(123);
            if (length == 1) {
                String key = keys.next();
                writer.write(JSONUtil.quote(key.toString()));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                InternalJSONUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                while (keys.hasNext()) {
                    String key = keys.next();
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    InternalJSONUtil.indent(writer, newindent);
                    writer.write(JSONUtil.quote(key.toString()));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    InternalJSONUtil.writeValue(writer, this.rawHashMap.get(key), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                InternalJSONUtil.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private void populateMap(Object bean) {
        Collection props = BeanUtil.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (null == value && this.ignoreNullValue || value == bean) continue;
            this.rawHashMap.put(prop.getFieldName(), JSONUtil.wrap(value, this.ignoreNullValue));
        }
    }

    private void init(String source) {
        this.init(new JSONTokener(source));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }
}

