/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.crypto.CryptoException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Element;

public class SpecUtil {
    public static KeySpec createKeySpec(String algorithm, byte[] key) {
        try {
            if (algorithm.startsWith("DESede")) {
                if (null == key) {
                    key = RandomUtil.randomBytes(24);
                }
                return new DESedeKeySpec(key);
            }
            if (algorithm.startsWith("DES")) {
                if (null == key) {
                    key = RandomUtil.randomBytes(8);
                }
                return new DESKeySpec(key);
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        return new SecretKeySpec(key, algorithm);
    }

    public static PBEKeySpec createPBEKeySpec(char[] password) {
        if (null == password) {
            password = RandomUtil.randomStringLower(32).toCharArray();
        }
        return new PBEKeySpec(password);
    }

    public static PBEParameterSpec createPBEParameterSpec(byte[] salt, int iterationCount) {
        return new PBEParameterSpec(salt, iterationCount);
    }

    public static RSAPrivateCrtKeySpec xmlToRSAPrivateCrtKeySpec(String xml) {
        Element rootElement = XmlUtil.getRootElement(XmlUtil.parseXml(xml));
        String modulusB64 = XmlUtil.elementText(rootElement, "Modulus");
        String exponentB64 = XmlUtil.elementText(rootElement, "Exponent");
        String pB64 = XmlUtil.elementText(rootElement, "P");
        String qB64 = XmlUtil.elementText(rootElement, "Q");
        String dpB64 = XmlUtil.elementText(rootElement, "DP");
        String dqB64 = XmlUtil.elementText(rootElement, "DQ");
        String inverseQB64 = XmlUtil.elementText(rootElement, "InverseQ");
        String dB64 = XmlUtil.elementText(rootElement, "D");
        byte[] modulus = Base64.decode(modulusB64);
        byte[] publicExponent = Base64.decode(exponentB64);
        byte[] privateExponent = Base64.decode(dB64);
        byte[] primeP = Base64.decode(pB64);
        byte[] primeQ = Base64.decode(qB64);
        byte[] primeExponentP = Base64.decode(dpB64);
        byte[] primeExponentQ = Base64.decode(dqB64);
        byte[] crtCoefficient = Base64.decode(inverseQB64);
        return new RSAPrivateCrtKeySpec(new BigInteger(1, modulus), new BigInteger(1, publicExponent), new BigInteger(1, privateExponent), new BigInteger(1, primeP), new BigInteger(1, primeQ), new BigInteger(1, primeExponentP), new BigInteger(1, primeExponentQ), new BigInteger(1, crtCoefficient));
    }
}

