/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.listener;

import cn.hutool.cron.TaskExecutor;
import cn.hutool.cron.listener.TaskListener;
import cn.hutool.log.StaticLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TaskListenerManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<TaskListener> listeners = new ArrayList<TaskListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskListenerManager addListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskListenerManager removeListener(TaskListener listener) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskStart(TaskExecutor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener taskListener : this.listeners) {
                TaskListener listener = taskListener;
                if (null == listener) continue;
                listener.onStart(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskSucceeded(TaskExecutor executor) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            for (TaskListener listener : this.listeners) {
                listener.onSucceeded(executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFailed(TaskExecutor executor, Throwable exception) {
        List<TaskListener> list = this.listeners;
        synchronized (list) {
            int size = this.listeners.size();
            if (size > 0) {
                for (TaskListener listener : this.listeners) {
                    listener.onFailed(executor, exception);
                }
            } else {
                StaticLog.error(exception, exception.getMessage(), new Object[0]);
            }
        }
    }
}

