/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.core;

import cn.hutool.ai.AIException;
import cn.hutool.ai.core.AIConfig;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import cn.hutool.json.JSONUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.function.Consumer;

public class BaseAIService {
    protected final AIConfig config;

    public BaseAIService(AIConfig config) {
        this.config = config;
    }

    protected HttpResponse sendGet(String endpoint) {
        try {
            return ((HttpRequest)((HttpRequest)HttpRequest.get(this.config.getApiUrl() + endpoint).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).timeout(this.config.getTimeout()).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send GET request: " + e.getMessage(), e);
        }
    }

    protected HttpResponse sendPost(String endpoint, String paramJson) {
        try {
            return ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "application/json")).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).body(paramJson).timeout(this.config.getTimeout()).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), e);
        }
    }

    protected HttpResponse sendFormData(String endpoint, Map<String, Object> paramMap) {
        try {
            return ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "multipart/form-data")).header(Header.ACCEPT, "application/json")).header(Header.AUTHORIZATION, "Bearer " + this.config.getApiKey())).form(paramMap).timeout(this.config.getTimeout()).execute();
        }
        catch (AIException e) {
            throw new AIException("Failed to send POST request\uff1a" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPostStream(String endpoint, Map<String, Object> paramMap, Consumer<String> callback) {
        HttpURLConnection connection = null;
        try {
            URL apiUrl = new URL(this.config.getApiUrl() + endpoint);
            connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod(Method.POST.name());
            connection.setRequestProperty(Header.CONTENT_TYPE.getValue(), "application/json");
            connection.setRequestProperty(Header.AUTHORIZATION.getValue(), "Bearer " + this.config.getApiKey());
            connection.setDoOutput(true);
            connection.setReadTimeout(this.config.getReadTimeout());
            connection.setConnectTimeout(this.config.getTimeout());
            try (OutputStream os = connection.getOutputStream();){
                String jsonInputString = JSONUtil.toJsonStr(paramMap);
                os.write(jsonInputString.getBytes());
                os.flush();
            }
            var7_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    callback.accept(line);
                }
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            callback.accept("{\"error\": \"" + e.getMessage() + "\"}");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

