/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.GlobalPruneTimer;
import cn.hutool.cache.impl.CacheObj;
import cn.hutool.cache.impl.StampedCache;
import cn.hutool.core.lang.mutable.Mutable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;

public class TimedCache<K, V>
extends StampedCache<K, V> {
    private static final long serialVersionUID = 1L;
    private ScheduledFuture<?> pruneJobFuture;

    public TimedCache(long timeout) {
        this(timeout, new HashMap<Mutable<K>, CacheObj<K, V>>());
    }

    public TimedCache(long timeout, Map<Mutable<K>, CacheObj<K, V>> map) {
        this.capacity = 0;
        this.timeout = timeout;
        this.cacheMap = map;
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObj co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.obj);
            ++count;
        }
        return count;
    }

    public void schedulePrune(long delay) {
        this.pruneJobFuture = GlobalPruneTimer.INSTANCE.schedule(this::prune, delay);
    }

    public void cancelPruneSchedule() {
        if (null != this.pruneJobFuture) {
            this.pruneJobFuture.cancel(true);
        }
    }
}

