/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.dbchange;

import cn.granitech.variantorm.metadata.ID;
import cn.granitech.variantorm.metadata.MetadataManager;
import cn.granitech.variantorm.persistence.EntityRecord;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.dialect.Dialect;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;

public class DBChangeHelper {
    private static final String SQL_TEXT_FIELD = "sqlText";
    private static final String SQL_NAME_FIELD = "sqlName";
    private static final String SQL_TYPE_FIELD = "sqlType";
    public static final String TABLE_DDL_DBC_TYPE = "TableDDL";
    public static final String COLUMN_DDL_DBC_TYPE = "ColumnDDL";
    public static final String META_ENTITY_DBC_TYPE = "MetaEntity";
    public static final String META_FIELD_DBC_TYPE = "MetaField";
    public static final String REFERENCE_LIST_DBC_TYPE = "ReferenceList";

    public static int jdbcUpdateWithLog(final PersistenceManager pm, MetadataManager mdm, String dbChangeType, JdbcTemplate jdbcTemplate, final String sql, final Object ... args) {
        final ArrayList sqlList = new ArrayList();
        int updateResult = jdbcTemplate.update(sql, (PreparedStatementSetter)new ArgumentPreparedStatementSetter(args){

            public void setValues(PreparedStatement ps) throws SQLException {
                super.setValues(ps);
                String dbType = pm.getSqlCompiler().getDatabaseType();
                String finalSql = ps.toString();
                if ("mysql".equalsIgnoreCase(dbType)) {
                    finalSql = finalSql.substring(finalSql.indexOf(58) + 1);
                } else if ("dameng".equalsIgnoreCase(dbType)) {
                    finalSql = SQLUtils.format((String)sql, (DbType)DbType.of((String)"dm"), Arrays.asList(args));
                } else if ("pgsql".equalsIgnoreCase(dbType) && finalSql.contains(" wrapping ")) {
                    finalSql = finalSql.substring(finalSql.indexOf(" wrapping ") + 10);
                }
                sqlList.add(finalSql);
            }
        });
        if (!sqlList.isEmpty()) {
            DBChangeHelper.saveDBChangeSqlUsingPM(pm, dbChangeType, (String)sqlList.get(0));
        }
        return updateResult;
    }

    private static void saveDBChangeSqlUsingPM(PersistenceManager pm, String dbChangeType, String sqlText) {
        EntityRecord devSqlHistoryRecord = pm.newRecord("DevSqlHistory");
        devSqlHistoryRecord.setFieldValue("createdBy", "0000021-00000000000000000000000000000001");
        devSqlHistoryRecord.setFieldValue("createdOn", new Date());
        devSqlHistoryRecord.setFieldValue("modifiedBy", "0000021-00000000000000000000000000000001");
        devSqlHistoryRecord.setFieldValue("modifiedOn", new Date());
        devSqlHistoryRecord.setFieldValue(SQL_TEXT_FIELD, sqlText);
        devSqlHistoryRecord.setFieldValue(SQL_TYPE_FIELD, dbChangeType);
        devSqlHistoryRecord.setFieldValue(SQL_NAME_FIELD, dbChangeType);
        try {
            pm.insert(devSqlHistoryRecord);
        }
        catch (Exception e) {
            System.err.println("sql of dbc: " + sqlText);
            e.printStackTrace();
        }
    }

    public static void saveDBChangeSqlUsingDS(PersistenceManager pm, String dbChangeType, String sqlText) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(pm.getDataSource());
        Dialect dialect = pm.getDialect();
        String insertSql = String.format(" INSERT INTO %s (`devSqlHistoryId`, `createdOn`, `createdBy`, `modifiedOn`,  `modifiedBy`, `sqlText`, `sqlName`, `sqlType`)  VALUES (?, ?, ?, ?, ?, ?, ?, ?) ", dialect.getQuotedTableName("t_dev_sql_history"));
        String newSql = dialect.replaceSql(insertSql);
        Date now = new Date();
        try {
            jdbcTemplate.update(newSql, new Object[]{ID.newID(60).toString(), now, "0000021-00000000000000000000000000000001", now, "0000021-00000000000000000000000000000001", sqlText, dbChangeType, dbChangeType});
        }
        catch (DataAccessException e) {
            System.err.println("sql of dbc: " + sqlText);
            e.printStackTrace();
        }
    }

    public static String formatParameterizedSql(String dbType, String sql, List<Object> paramValueList) {
        DbType druidDbType = null;
        boolean escapingReplaceFlag = false;
        if ("dameng".equalsIgnoreCase(dbType)) {
            druidDbType = DbType.of((String)"dm");
        } else if ("pgsql".equalsIgnoreCase(dbType)) {
            druidDbType = DbType.of((String)"postgresql");
        } else {
            escapingReplaceFlag = true;
            druidDbType = DbType.of((String)"mysql");
        }
        String outputSql = SQLUtils.format((String)sql, (DbType)druidDbType, paramValueList);
        if (!escapingReplaceFlag) {
            outputSql = outputSql.replaceAll("\\\\\\\\\"", "\\\\\"");
        }
        return outputSql;
    }

    public static void main(String[] args) {
        String t1 = "\\\\\"123";
        System.err.println("t1: " + t1);
        t1 = t1.replaceAll("\\\\\\\\\"", "\\\\\"");
        System.err.println("t1: " + t1);
        String testSql = " insert into t_test_table (aa, bb) values (?, ?) ";
        ArrayList<Object> paramValueList = new ArrayList<Object>();
        paramValueList.add(123);
        paramValueList.add("[{\n\t\"celldata\": [{\n\t\t\"r\": 0,\n\t\t\"c\": 0,\n\t\t\"v\": {\n\t\t\t\"m\": \"\u3010\u6587\u672c\u3011\",\n\t\t\t\"ct\": {\n\t\t\t\t\"fa\": \"General\",\n\t\t\t\t\"t\": \"g\"\n\t\t\t},\n\t\t\t\"v\": \"\u3010\u6587\u672c\u3011\",\n\t\t\t\"ps\": {\n\t\t\t\t\"value\": \"{\\\"code\\\":\\\"wenben\\\",\\\"name\\\":\\\"\u6587\u672c\\\",\\\"type\\\":\\\"Text\\\"}\",\n\t\t\t\t\"isshow\": true\n\t\t\t}\n\t\t}\n\t}]\n}]");
        String outputSql = DBChangeHelper.formatParameterizedSql("pgsql", testSql, paramValueList);
        System.err.println("output sql: " + outputSql);
    }

    public static void jdbcExecuteWithLog(PersistenceManager pm, String dbChangeType, JdbcTemplate jdbcTemplate, String sql) {
        jdbcTemplate.execute(sql);
        DBChangeHelper.saveDBChangeSqlUsingPM(pm, dbChangeType, sql);
    }

    public static boolean sqlLogIsEnabled(String entityName) {
        return "OptionItem".equalsIgnoreCase(entityName) || "CodeOptionItem".equalsIgnoreCase(entityName) || "CascaderOptionItem".equalsIgnoreCase(entityName) || "TagItem".equalsIgnoreCase(entityName) || "FormLayout".equalsIgnoreCase(entityName) || "Role".equalsIgnoreCase(entityName) || "RouterMenu".equalsIgnoreCase(entityName) || "ApprovalConfig".equalsIgnoreCase(entityName) || "ApprovalFlow".equalsIgnoreCase(entityName) || "ReportConfig".equalsIgnoreCase(entityName) || "TriggerConfig".equalsIgnoreCase(entityName) || "LayoutConfig".equalsIgnoreCase(entityName) || "MetaApi".equalsIgnoreCase(entityName) || "Chart".equalsIgnoreCase(entityName) || "ExternalForm".equalsIgnoreCase(entityName) || "Transform".equalsIgnoreCase(entityName) || "SystemConstant".equalsIgnoreCase(entityName) || "User".equalsIgnoreCase(entityName) || "Department".equalsIgnoreCase(entityName) || "Team".equalsIgnoreCase(entityName) || "CustomMethod".equalsIgnoreCase(entityName) || "I18n".equalsIgnoreCase(entityName) || "I18nItem".equalsIgnoreCase(entityName);
    }
}

