/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.servlet.model;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.application.ApplicationInfo;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaRequestForServlet
implements SaRequest {
    protected HttpServletRequest request;

    public SaRequestForServlet(HttpServletRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public Collection<String> getParamNames() {
        return Collections.list(this.request.getParameterNames());
    }

    public Map<String, String> getParamMap() {
        Map parameterMap = this.request.getParameterMap();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(parameterMap.size());
        for (String key : parameterMap.keySet()) {
            String[] values = (String[])parameterMap.get(key);
            map.put(key, values[0]);
        }
        return map;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getCookieValue(String name) {
        return this.getCookieLastValue(name);
    }

    public String getCookieFirstValue(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getCookieLastValue(String name) {
        String value = null;
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                value = cookie.getValue();
            }
        }
        return value;
    }

    public String getRequestPath() {
        return ApplicationInfo.cutPathPrefix((String)this.request.getRequestURI());
    }

    public String getUrl() {
        String currDomain = SaManager.getConfig().getCurrDomain();
        if (!SaFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getRequestURL().toString();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Object forward(String path) {
        try {
            HttpServletResponse response = (HttpServletResponse)SaManager.getSaTokenContextOrSecond().getResponse().getSource();
            this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)response);
            return null;
        }
        catch (IOException | ServletException e) {
            throw new SaTokenException(e).setCode(20001);
        }
    }
}

