/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao;

import cn.dev33.satoken.dao.auto.SaTokenDaoByObjectFollowString;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class SaTokenDaoForRedisTemplate
implements SaTokenDaoByObjectFollowString {
    public StringRedisTemplate stringRedisTemplate;
    public boolean isInit;

    @Autowired
    public void init(RedisConnectionFactory connectionFactory) {
        if (this.isInit) {
            return;
        }
        StringRedisTemplate stringTemplate = new StringRedisTemplate();
        stringTemplate.setConnectionFactory(connectionFactory);
        stringTemplate.afterPropertiesSet();
        this.stringRedisTemplate = stringTemplate;
        this.initMore(connectionFactory);
        this.isInit = true;
    }

    protected void initMore(RedisConnectionFactory connectionFactory) {
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, String value, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, timeout, TimeUnit.SECONDS);
        }
    }

    public void update(String key, String value) {
        long expire = this.getTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.set(key, value, expire);
    }

    public void delete(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public long getTimeout(String key) {
        return this.stringRedisTemplate.getExpire((Object)key);
    }

    public void updateTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.set(key, this.get(key), timeout);
            }
            return;
        }
        this.stringRedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        Set keys = this.stringRedisTemplate.keys((Object)(prefix + "*" + keyword + "*"));
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

