/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.reactor.filter;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.exception.FirewallCheckException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.reactor.model.SaRequestForReactor;
import cn.dev33.satoken.reactor.model.SaResponseForReactor;
import cn.dev33.satoken.strategy.SaFirewallStrategy;
import org.reactivestreams.Publisher;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-1000)
public class SaFirewallCheckFilterForReactor
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        SaRequestForReactor saRequest = new SaRequestForReactor(exchange.getRequest());
        SaResponseForReactor saResponse = new SaResponseForReactor(exchange.getResponse());
        try {
            SaFirewallStrategy.instance.check.execute((SaRequest)saRequest, (SaResponse)saResponse, (Object)exchange);
        }
        catch (StopMatchException stopMatchException) {
        }
        catch (FirewallCheckException e) {
            if (SaFirewallStrategy.instance.checkFailHandle == null) {
                exchange.getResponse().getHeaders().set("Content-Type", "text/plain; charset=utf-8");
                return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(e.getMessage().getBytes())));
            }
            SaFirewallStrategy.instance.checkFailHandle.run(e, (SaRequest)saRequest, (SaResponse)saResponse, null);
            return Mono.empty();
        }
        return chain.filter(exchange);
    }
}

