/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class AccessTokenModel
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String accessToken;
    public String refreshToken;
    public long expiresTime;
    public long refreshExpiresTime;
    public String clientId;
    public Object loginId;
    public String openid;
    public String scope;

    public AccessTokenModel() {
    }

    public AccessTokenModel(String accessToken, String clientId, Object loginId, String scope) {
        this.accessToken = accessToken;
        this.clientId = clientId;
        this.loginId = loginId;
        this.scope = scope;
    }

    public String toString() {
        return "AccessTokenModel [accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", accessTokenTimeout=" + this.expiresTime + ", refreshTokenTimeout=" + this.refreshExpiresTime + ", clientId=" + this.clientId + ", scope=" + this.scope + ", openid=" + this.openid + "]";
    }

    public long getExpiresIn() {
        long s = (this.expiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public long getRefreshExpiresIn() {
        long s = (this.refreshExpiresTime - System.currentTimeMillis()) / 1000L;
        return s < 1L ? -2L : s;
    }

    public Map<String, Object> toLineMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("access_token", this.accessToken);
        map.put("refresh_token", this.refreshToken);
        map.put("expires_in", this.getExpiresIn());
        map.put("refresh_expires_in", this.getRefreshExpiresIn());
        map.put("client_id", this.clientId);
        map.put("scope", this.scope);
        map.put("openid", this.openid);
        return map;
    }
}

