/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.logic;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.oauth2.logic.SaOAuth2Template;
import cn.dev33.satoken.oauth2.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.model.CodeModel;
import cn.dev33.satoken.oauth2.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.model.RequestAuthModel;
import cn.dev33.satoken.oauth2.model.SaClientModel;

public class SaOAuth2Util {
    public static SaOAuth2Template saOAuth2Template = new SaOAuth2Template();

    public static SaClientModel checkClientModel(String clientId) {
        return saOAuth2Template.checkClientModel(clientId);
    }

    public static AccessTokenModel checkAccessToken(String accessToken) {
        return saOAuth2Template.checkAccessToken(accessToken);
    }

    public static ClientTokenModel checkClientToken(String clientToken) {
        return saOAuth2Template.checkClientToken(clientToken);
    }

    public static Object getLoginIdByAccessToken(String accessToken) {
        return saOAuth2Template.getLoginIdByAccessToken(accessToken);
    }

    public static void checkScope(String accessToken, String ... scopes) {
        saOAuth2Template.checkScope(accessToken, scopes);
    }

    public static RequestAuthModel generateRequestAuth(SaRequest req, Object loginId) {
        return saOAuth2Template.generateRequestAuth(req, loginId);
    }

    public static CodeModel generateCode(RequestAuthModel ra) {
        return saOAuth2Template.generateCode(ra);
    }

    public static AccessTokenModel generateAccessToken(String code) {
        return saOAuth2Template.generateAccessToken(code);
    }

    public static AccessTokenModel refreshAccessToken(String refreshToken) {
        return saOAuth2Template.refreshAccessToken(refreshToken);
    }

    public static AccessTokenModel generateAccessToken(RequestAuthModel ra, boolean isCreateRt) {
        return saOAuth2Template.generateAccessToken(ra, isCreateRt);
    }

    public static ClientTokenModel generateClientToken(String clientId, String scope) {
        return saOAuth2Template.generateClientToken(clientId, scope);
    }

    public static String buildRedirectUri(String redirectUri, String code, String state) {
        return saOAuth2Template.buildRedirectUri(redirectUri, code, state);
    }

    public static String buildImplicitRedirectUri(String redirectUri, String token, String state) {
        return saOAuth2Template.buildImplicitRedirectUri(redirectUri, token, state);
    }

    public static void revokeAccessToken(String accessToken) {
        saOAuth2Template.revokeAccessToken(accessToken);
    }

    public static boolean isGrant(Object loginId, String clientId, String scope) {
        return saOAuth2Template.isGrant(loginId, clientId, scope);
    }

    public static void checkContract(String clientId, String scope) {
        saOAuth2Template.checkContract(clientId, scope);
    }

    public static void checkRightUrl(String clientId, String url) {
        saOAuth2Template.checkRightUrl(clientId, url);
    }

    public static SaClientModel checkClientSecret(String clientId, String clientSecret) {
        return saOAuth2Template.checkClientSecret(clientId, clientSecret);
    }

    public static CodeModel checkGainTokenParam(String code, String clientId, String clientSecret, String redirectUri) {
        return saOAuth2Template.checkGainTokenParam(code, clientId, clientSecret, redirectUri);
    }

    public static RefreshTokenModel checkRefreshTokenParam(String clientId, String clientSecret, String refreshToken) {
        return saOAuth2Template.checkRefreshTokenParam(clientId, clientSecret, refreshToken);
    }

    public static AccessTokenModel checkAccessTokenParam(String clientId, String clientSecret, String accessToken) {
        return saOAuth2Template.checkAccessTokenParam(clientId, clientSecret, accessToken);
    }

    public static void saveGrantScope(String clientId, Object loginId, String scope) {
        saOAuth2Template.saveGrantScope(clientId, loginId, scope);
    }

    public static CodeModel getCode(String code) {
        return saOAuth2Template.getCode(code);
    }

    public static AccessTokenModel getAccessToken(String accessToken) {
        return saOAuth2Template.getAccessToken(accessToken);
    }

    public static RefreshTokenModel getRefreshToken(String refreshToken) {
        return saOAuth2Template.getRefreshToken(refreshToken);
    }

    public static ClientTokenModel getClientToken(String clientToken) {
        return saOAuth2Template.getClientToken(clientToken);
    }

    public static String getGrantScope(String clientId, Object loginId) {
        return saOAuth2Template.getGrantScope(clientId, loginId);
    }
}

